/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.ContentPart;
import com.myscript.iink.Engine;
import com.myscript.iink.NativeFunctions;
import com.myscript.iink.ParameterSet;
import com.myscript.util.IAutoCloseable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class ContentPackage
implements IAutoCloseable {
    Engine engine;
    long nativeRef;

    ContentPackage(Engine engine, long nativeRef) {
        this.engine = engine;
        this.nativeRef = nativeRef;
    }

    @Override
    public final void close() {
        if (this.nativeRef != 0L) {
            NativeFunctions.destroyPackage(this.nativeRef);
            this.nativeRef = 0L;
        }
    }

    public final boolean isClosed() {
        return this.nativeRef == 0L;
    }

    private final void checkNotClosed() {
        if (this.nativeRef == 0L) {
            throw new IllegalStateException(this.getClass().getName() + " closed");
        }
    }

    public final void save() throws IOException {
        this.checkNotClosed();
        NativeFunctions.save(this.nativeRef);
    }

    public final void saveToTemp() throws IOException {
        this.checkNotClosed();
        NativeFunctions.saveToTemp(this.nativeRef);
    }

    public final void saveAs(File file) throws IOException {
        this.checkNotClosed();
        NativeFunctions.saveAs(this.nativeRef, file.getAbsolutePath());
    }

    public final int getPartCount() {
        this.checkNotClosed();
        return NativeFunctions.getPartCount(this.nativeRef);
    }

    public final ContentPart getPart(int index) throws IndexOutOfBoundsException {
        this.checkNotClosed();
        return new ContentPart(this, NativeFunctions.getPartByIndex(this.nativeRef, index));
    }

    public final ContentPart getPart(String id) throws IllegalArgumentException {
        this.checkNotClosed();
        return new ContentPart(this, NativeFunctions.getPartById(this.nativeRef, id));
    }

    public final int indexOfPart(ContentPart part) {
        this.checkNotClosed();
        part.checkNotClosed();
        return NativeFunctions.indexOfPart(this.nativeRef, part.nativeRef);
    }

    public final ContentPart createPart(String type) throws IllegalArgumentException {
        this.checkNotClosed();
        if (!Arrays.asList(this.engine.getSupportedPartTypes()).contains(type)) {
            throw new IllegalArgumentException("Invalid part type: " + type);
        }
        return new ContentPart(this, NativeFunctions.createPart(this.nativeRef, type));
    }

    public final void removePart(ContentPart part) throws IllegalArgumentException {
        this.checkNotClosed();
        part.checkNotClosed();
        NativeFunctions.removePart(this.nativeRef, part.nativeRef);
    }

    public final ContentPart clonePart(ContentPart part) {
        this.checkNotClosed();
        part.checkNotClosed();
        return new ContentPart(this, NativeFunctions.clonePart(this.nativeRef, part.nativeRef));
    }

    public final void extractObject(String url, File file) throws IOException, IllegalArgumentException {
        this.checkNotClosed();
        NativeFunctions.extractObject(this.nativeRef, url, file.getAbsolutePath());
    }

    public final ParameterSet getMetadata() {
        this.checkNotClosed();
        return new ParameterSet(NativeFunctions.getPackageMetadata(this.nativeRef));
    }

    public final void setMetadata(ParameterSet parameters) {
        this.checkNotClosed();
        parameters.checkNotClosed();
        NativeFunctions.setPackageMetadata(this.nativeRef, parameters.nativeRef);
    }
}

