/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.ContentTree;
import com.myscript.iink.ConversionState;
import com.myscript.iink.graphics.Rectangle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

class ContentNode {
    private final ContentTree owner;
    private String type;
    private final String id;
    private String renderingId;
    private String attributes;
    private Rectangle box;
    private ContentNode parent;
    private List<ContentNode> children;
    private EnumSet<ConversionState> conversionState;

    ContentNode(ContentTree owner, String type, String id, String renderingId, Rectangle box, int conversionState, String attributes) {
        this.owner = owner;
        this.type = type;
        this.id = id;
        this.renderingId = renderingId;
        this.attributes = attributes;
        this.box = box;
        this.conversionState = EnumSet.noneOf(ConversionState.class);
        if ((conversionState & 1 << ConversionState.HANDWRITING.ordinal()) != 0) {
            this.conversionState.add(ConversionState.HANDWRITING);
        }
        if ((conversionState & 1 << ConversionState.DIGITAL_PUBLISH.ordinal()) != 0) {
            this.conversionState.add(ConversionState.DIGITAL_PUBLISH);
        }
        if ((conversionState & 1 << ConversionState.DIGITAL_EDIT.ordinal()) != 0) {
            this.conversionState.add(ConversionState.DIGITAL_EDIT);
        }
        this.parent = null;
        this.children = null;
    }

    public final ContentTree getOwner() {
        return this.owner;
    }

    public final boolean isDetached() {
        return this.owner.getNodeById(this.id) != this;
    }

    public final String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public final String getId() {
        return this.id;
    }

    public final String getRenderingId() {
        return this.renderingId;
    }

    final void setRenderingId(String renderingId) {
        this.renderingId = renderingId;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    final void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public final Rectangle getBox() {
        return this.box;
    }

    final void setBox(Rectangle box) {
        this.box = box;
    }

    public final ContentNode getParent() {
        return this.parent;
    }

    public final int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public final ContentNode getChildAt(int index) throws IndexOutOfBoundsException {
        int count;
        int n = count = this.children == null ? 0 : this.children.size();
        if (index < 0 || index >= count) {
            throw new IndexOutOfBoundsException();
        }
        return this.children.get(index);
    }

    public final int indexOfChild(ContentNode child) {
        if (this.children == null) {
            return -1;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            if (this.children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    public final ContentNode removeChild(int index) throws IndexOutOfBoundsException {
        ContentNode child = null;
        if (this.children == null || index < 0 || index >= this.children.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index != -1) {
            child = this.children.remove(index);
            child.parent = null;
        }
        return child;
    }

    public final void removeChild(ContentNode child) {
        int index = this.indexOfChild(child);
        if (index != -1) {
            this.children.remove(index);
            child.parent = null;
        }
    }

    public final void clearChildren() {
        this.children = null;
    }

    public final void addChild(ContentNode child) {
        this.addChild(this.children == null ? 0 : this.children.size(), child);
    }

    public final void addChild(int index, ContentNode child) throws IllegalArgumentException {
        if (child == this) {
            throw new IllegalArgumentException("trying to add node as child of himself");
        }
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        if (this.children == null) {
            this.children = new ArrayList<ContentNode>();
        }
        this.children.add(index, child);
        child.parent = this;
    }

    final ContentNode replaceChild(int index, ContentNode newChild) {
        ContentNode oldChild = null;
        if (this.children == null || index < 0 || index >= this.children.size()) {
            throw new IndexOutOfBoundsException();
        }
        oldChild = this.children.set(index, newChild);
        oldChild.parent = null;
        return oldChild;
    }

    public final void setConversionState(EnumSet<ConversionState> conversionState) {
        this.conversionState = conversionState;
    }

    public final EnumSet<ConversionState> getConversionState() {
        return this.conversionState;
    }
}

