/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.ContentNode;
import com.myscript.iink.ContentPart;
import com.myscript.iink.ContentTree;
import com.myscript.iink.ConversionState;
import com.myscript.iink.graphics.Rectangle;
import java.util.EnumSet;

public class ContentBlock {
    public static final String CONTAINER_TYPE = "Container";
    private ContentPart part;
    private ContentNode node;

    ContentBlock(ContentPart part, ContentNode node) {
        this.part = part;
        this.node = node;
    }

    public final ContentPart getPart() {
        return this.part;
    }

    public final boolean isValid() {
        return !this.node.isDetached();
    }

    public final String getType() {
        return this.node.getType();
    }

    public final String getId() {
        return this.node.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getRenderingId() {
        ContentTree contentTree = this.node.getOwner();
        synchronized (contentTree) {
            return this.node.getRenderingId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAttributes() {
        ContentTree contentTree = this.node.getOwner();
        synchronized (contentTree) {
            return this.node.getAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Rectangle getBox() {
        ContentTree contentTree = this.node.getOwner();
        synchronized (contentTree) {
            return this.node.getBox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContentBlock[] getChildren() {
        ContentTree contentTree = this.node.getOwner();
        synchronized (contentTree) {
            ContentBlock[] children = new ContentBlock[this.node.getChildCount()];
            for (int i = 0; i < children.length; ++i) {
                children[i] = new ContentBlock(this.part, this.node.getChildAt(i));
            }
            return children;
        }
    }

    public final EnumSet<ConversionState> getConversionState() {
        return this.node.getConversionState();
    }
}

