/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AsyncQueryStatus
implements Serializable {
    private StateEnum state = null;
    private String errorMessage = null;
    private Date expirationDate = null;
    private Date submissionDate = null;
    private Date completionDate = null;

    public AsyncQueryStatus state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The current state of the asynchronous query")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public AsyncQueryStatus errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The error associated with the current query, if the state is FAILED")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public AsyncQueryStatus expirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The time at which results for this query will expire. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="expirationDate")
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public AsyncQueryStatus submissionDate(Date submissionDate) {
        this.submissionDate = submissionDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The time at which the query was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="submissionDate")
    public Date getSubmissionDate() {
        return this.submissionDate;
    }

    public void setSubmissionDate(Date submissionDate) {
        this.submissionDate = submissionDate;
    }

    public AsyncQueryStatus completionDate(Date completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The time at which the query completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="completionDate")
    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncQueryStatus asyncQueryStatus = (AsyncQueryStatus)o;
        return Objects.equals((Object)this.state, (Object)asyncQueryStatus.state) && Objects.equals(this.errorMessage, asyncQueryStatus.errorMessage) && Objects.equals(this.expirationDate, asyncQueryStatus.expirationDate) && Objects.equals(this.submissionDate, asyncQueryStatus.submissionDate) && Objects.equals(this.completionDate, asyncQueryStatus.completionDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.errorMessage, this.expirationDate, this.submissionDate, this.completionDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AsyncQueryStatus {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    submissionDate: ").append(this.toIndentedString(this.submissionDate)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("QUEUED"),
        PENDING("PENDING"),
        FAILED("FAILED"),
        CANCELLED("CANCELLED"),
        FULFILLED("FULFILLED"),
        EXPIRED("EXPIRED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

