/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetFlowsDatatableImportJobRequest {
    private String datatableId;
    private String importJobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDatatableId() {
        return this.datatableId;
    }

    public void setDatatableId(String datatableId) {
        this.datatableId = datatableId;
    }

    public GetFlowsDatatableImportJobRequest withDatatableId(String datatableId) {
        this.setDatatableId(datatableId);
        return this;
    }

    public String getImportJobId() {
        return this.importJobId;
    }

    public void setImportJobId(String importJobId) {
        this.importJobId = importJobId;
    }

    public GetFlowsDatatableImportJobRequest withImportJobId(String importJobId) {
        this.setImportJobId(importJobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetFlowsDatatableImportJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.datatableId == null) {
            throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for GetFlowsDatatableImportJobRequest.");
        }
        if (this.importJobId == null) {
            throw new IllegalStateException("Missing the required parameter 'importJobId' when building request for GetFlowsDatatableImportJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/flows/datatables/{datatableId}/import/jobs/{importJobId}").withPathParameter("datatableId", this.datatableId).withPathParameter("importJobId", this.importJobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String datatableId, String importJobId) {
        return new Builder().withRequiredParams(datatableId, importJobId);
    }

    public static class Builder {
        private final GetFlowsDatatableImportJobRequest request = new GetFlowsDatatableImportJobRequest();

        private Builder() {
        }

        public Builder withDatatableId(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public Builder withImportJobId(String importJobId) {
            this.request.setImportJobId(importJobId);
            return this;
        }

        public Builder withRequiredParams(String datatableId, String importJobId) {
            this.request.setDatatableId(datatableId);
            this.request.setImportJobId(importJobId);
            return this;
        }

        public GetFlowsDatatableImportJobRequest build() {
            if (this.request.datatableId == null) {
                throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for GetFlowsDatatableImportJobRequest.");
            }
            if (this.request.importJobId == null) {
                throw new IllegalStateException("Missing the required parameter 'importJobId' when building request for GetFlowsDatatableImportJobRequest.");
            }
            return this.request;
        }
    }
}

