/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.SourcePlanningGroupRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Route path configuration")
public class RoutePathRequest
implements Serializable {
    private String queueId = null;
    private MediaTypeEnum mediaType = null;
    private String languageId = null;
    private List<String> skillIds = new ArrayList<String>();
    private SourcePlanningGroupRequest sourcePlanningGroup = null;

    public RoutePathRequest queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="f27450c9-c1a0-451a-804c-2579b268b273", required=true, value="The ID of the queue to associate with the route path")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public RoutePathRequest mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="Email", required=true, value="The media type of the given queue to associate with the route path")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public RoutePathRequest languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="e3d65f6a-c0d2-41da-8152-82d3f075d77c", value="The ID of the language to associate with the route path")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public RoutePathRequest skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of skill IDs to associate with the route path")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public RoutePathRequest sourcePlanningGroup(SourcePlanningGroupRequest sourcePlanningGroup) {
        this.sourcePlanningGroup = sourcePlanningGroup;
        return this;
    }

    @ApiModelProperty(example="null", value="The planning group from which to copy route paths")
    @JsonProperty(value="sourcePlanningGroup")
    public SourcePlanningGroupRequest getSourcePlanningGroup() {
        return this.sourcePlanningGroup;
    }

    public void setSourcePlanningGroup(SourcePlanningGroupRequest sourcePlanningGroup) {
        this.sourcePlanningGroup = sourcePlanningGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutePathRequest routePathRequest = (RoutePathRequest)o;
        return Objects.equals(this.queueId, routePathRequest.queueId) && Objects.equals((Object)this.mediaType, (Object)routePathRequest.mediaType) && Objects.equals(this.languageId, routePathRequest.languageId) && Objects.equals(this.skillIds, routePathRequest.skillIds) && Objects.equals(this.sourcePlanningGroup, routePathRequest.sourcePlanningGroup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queueId, this.mediaType, this.languageId, this.skillIds, this.sourcePlanningGroup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutePathRequest {\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    sourcePlanningGroup: ").append(this.toIndentedString(this.sourcePlanningGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        CHAT("Chat"),
        EMAIL("Email"),
        CALLBACK("Callback"),
        MESSAGE("Message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

