/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeSearchRequest
implements Serializable {
    private String query = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private DocumentTypeEnum documentType = null;
    private String languageCode = null;
    private Boolean searchOnDraftDocuments = null;

    public KnowledgeSearchRequest query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Input query to search content in the knowledge base")
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public KnowledgeSearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Page size of the returned results")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeSearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Page number of the returned results")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public KnowledgeSearchRequest documentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Document type to be used while searching")
    @JsonProperty(value="documentType")
    public DocumentTypeEnum getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
    }

    public KnowledgeSearchRequest languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="query search for specific languageCode")
    @JsonProperty(value="languageCode")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public KnowledgeSearchRequest searchOnDraftDocuments(Boolean searchOnDraftDocuments) {
        this.searchOnDraftDocuments = searchOnDraftDocuments;
        return this;
    }

    @ApiModelProperty(example="null", value="If true the search query will be executed on draft documents, else it will be on active documents")
    @JsonProperty(value="searchOnDraftDocuments")
    public Boolean getSearchOnDraftDocuments() {
        return this.searchOnDraftDocuments;
    }

    public void setSearchOnDraftDocuments(Boolean searchOnDraftDocuments) {
        this.searchOnDraftDocuments = searchOnDraftDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeSearchRequest knowledgeSearchRequest = (KnowledgeSearchRequest)o;
        return Objects.equals(this.query, knowledgeSearchRequest.query) && Objects.equals(this.pageSize, knowledgeSearchRequest.pageSize) && Objects.equals(this.pageNumber, knowledgeSearchRequest.pageNumber) && Objects.equals((Object)this.documentType, (Object)knowledgeSearchRequest.documentType) && Objects.equals(this.languageCode, knowledgeSearchRequest.languageCode) && Objects.equals(this.searchOnDraftDocuments, knowledgeSearchRequest.searchOnDraftDocuments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.pageSize, this.pageNumber, this.documentType, this.languageCode, this.searchOnDraftDocuments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeSearchRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    searchOnDraftDocuments: ").append(this.toIndentedString(this.searchOnDraftDocuments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DocumentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FAQ("Faq");

        private String value;

        private DocumentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DocumentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DocumentTypeEnum value : DocumentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DocumentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

