/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetRoutingMessageRecipientRequest {
    private String recipientId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public GetRoutingMessageRecipientRequest withRecipientId(String recipientId) {
        this.setRecipientId(recipientId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetRoutingMessageRecipientRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.recipientId == null) {
            throw new IllegalStateException("Missing the required parameter 'recipientId' when building request for GetRoutingMessageRecipientRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/routing/message/recipients/{recipientId}").withPathParameter("recipientId", this.recipientId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String recipientId) {
        return new Builder().withRequiredParams(recipientId);
    }

    public static class Builder {
        private final GetRoutingMessageRecipientRequest request = new GetRoutingMessageRecipientRequest();

        private Builder() {
        }

        public Builder withRecipientId(String recipientId) {
            this.request.setRecipientId(recipientId);
            return this;
        }

        public Builder withRequiredParams(String recipientId) {
            this.request.setRecipientId(recipientId);
            return this;
        }

        public GetRoutingMessageRecipientRequest build() {
            if (this.request.recipientId == null) {
                throw new IllegalStateException("Missing the required parameter 'recipientId' when building request for GetRoutingMessageRecipientRequest.");
            }
            return this.request;
        }
    }
}

