/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Entity;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class OrgOAuthClient
implements Serializable {
    private String id = null;
    private String name = null;
    private AuthorizedGrantTypeEnum authorizedGrantType = null;
    private Entity organization = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OrgOAuthClient name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the OAuth client.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrgOAuthClient authorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client. ")
    @JsonProperty(value="authorizedGrantType")
    public AuthorizedGrantTypeEnum getAuthorizedGrantType() {
        return this.authorizedGrantType;
    }

    public void setAuthorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
    }

    public OrgOAuthClient organization(Entity organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(example="null", value="The  oauth client's organization.")
    @JsonProperty(value="organization")
    public Entity getOrganization() {
        return this.organization;
    }

    public void setOrganization(Entity organization) {
        this.organization = organization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgOAuthClient orgOAuthClient = (OrgOAuthClient)o;
        return Objects.equals(this.id, orgOAuthClient.id) && Objects.equals(this.name, orgOAuthClient.name) && Objects.equals((Object)this.authorizedGrantType, (Object)orgOAuthClient.authorizedGrantType) && Objects.equals(this.organization, orgOAuthClient.organization);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.authorizedGrantType, this.organization});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgOAuthClient {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    authorizedGrantType: ").append(this.toIndentedString((Object)this.authorizedGrantType)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthorizedGrantTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CODE("CODE"),
        TOKEN("TOKEN"),
        SAML2BEARER("SAML2BEARER"),
        PASSWORD("PASSWORD"),
        CLIENT_CREDENTIALS("CLIENT_CREDENTIALS");

        private String value;

        private AuthorizedGrantTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthorizedGrantTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AuthorizedGrantTypeEnum value : AuthorizedGrantTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AuthorizedGrantTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

