/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteOauthClientRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientsRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientSecretRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientsRequest;
import com.mypurecloud.sdk.v2.api.request.PutOauthClientRequest;
import com.mypurecloud.sdk.v2.model.OAuthClient;
import com.mypurecloud.sdk.v2.model.OAuthClientEntityListing;
import java.io.IOException;

public class OAuthApi {
    private final ApiClient pcapiClient;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteOauthClient(String clientId) throws IOException, ApiException {
        this.deleteOauthClient(this.createDeleteOauthClientRequest(clientId));
    }

    public ApiResponse<Void> deleteOauthClientWithHttpInfo(String clientId) throws IOException {
        return this.deleteOauthClient(this.createDeleteOauthClientRequest(clientId).withHttpInfo());
    }

    private DeleteOauthClientRequest createDeleteOauthClientRequest(String clientId) {
        return DeleteOauthClientRequest.builder().withClientId(clientId).build();
    }

    public void deleteOauthClient(DeleteOauthClientRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse response = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteOauthClient(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient getOauthClient(String clientId) throws IOException, ApiException {
        return this.getOauthClient(this.createGetOauthClientRequest(clientId));
    }

    public ApiResponse<OAuthClient> getOauthClientWithHttpInfo(String clientId) throws IOException {
        return this.getOauthClient(this.createGetOauthClientRequest(clientId).withHttpInfo());
    }

    private GetOauthClientRequest createGetOauthClientRequest(String clientId) {
        return GetOauthClientRequest.builder().withClientId(clientId).build();
    }

    public OAuthClient getOauthClient(GetOauthClientRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> getOauthClient(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClientEntityListing getOauthClients() throws IOException, ApiException {
        return this.getOauthClients(this.createGetOauthClientsRequest());
    }

    public ApiResponse<OAuthClientEntityListing> getOauthClientsWithHttpInfo() throws IOException {
        return this.getOauthClients(this.createGetOauthClientsRequest().withHttpInfo());
    }

    private GetOauthClientsRequest createGetOauthClientsRequest() {
        return GetOauthClientsRequest.builder().build();
    }

    public OAuthClientEntityListing getOauthClients(GetOauthClientsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClientEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClientEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClientEntityListing> getOauthClients(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClientEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient postOauthClientSecret(String clientId) throws IOException, ApiException {
        return this.postOauthClientSecret(this.createPostOauthClientSecretRequest(clientId));
    }

    public ApiResponse<OAuthClient> postOauthClientSecretWithHttpInfo(String clientId) throws IOException {
        return this.postOauthClientSecret(this.createPostOauthClientSecretRequest(clientId).withHttpInfo());
    }

    private PostOauthClientSecretRequest createPostOauthClientSecretRequest(String clientId) {
        return PostOauthClientSecretRequest.builder().withClientId(clientId).build();
    }

    public OAuthClient postOauthClientSecret(PostOauthClientSecretRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> postOauthClientSecret(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient postOauthClients(OAuthClient body) throws IOException, ApiException {
        return this.postOauthClients(this.createPostOauthClientsRequest(body));
    }

    public ApiResponse<OAuthClient> postOauthClientsWithHttpInfo(OAuthClient body) throws IOException {
        return this.postOauthClients(this.createPostOauthClientsRequest(body).withHttpInfo());
    }

    private PostOauthClientsRequest createPostOauthClientsRequest(OAuthClient body) {
        return PostOauthClientsRequest.builder().withBody(body).build();
    }

    public OAuthClient postOauthClients(PostOauthClientsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> postOauthClients(ApiRequest<OAuthClient> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient putOauthClient(String clientId, OAuthClient body) throws IOException, ApiException {
        return this.putOauthClient(this.createPutOauthClientRequest(clientId, body));
    }

    public ApiResponse<OAuthClient> putOauthClientWithHttpInfo(String clientId, OAuthClient body) throws IOException {
        return this.putOauthClient(this.createPutOauthClientRequest(clientId, body).withHttpInfo());
    }

    private PutOauthClientRequest createPutOauthClientRequest(String clientId, OAuthClient body) {
        return PutOauthClientRequest.builder().withClientId(clientId).withBody(body).build();
    }

    public OAuthClient putOauthClient(PutOauthClientRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> putOauthClient(ApiRequest<OAuthClient> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

