/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class UserPresenceAlert
implements Serializable {
    private String id = null;
    private String name = null;
    private User presenceUser = null;
    private PresenceTypeEnum presenceType = null;
    private String presenceValue = null;
    private Integer presenceLimitInSeconds = null;
    private String ruleId = null;
    private Date startDate = null;
    private Date endDate = null;
    private List<User> notificationUsers = new ArrayList<User>();
    private List<AlertTypesEnum> alertTypes = new ArrayList<AlertTypesEnum>();
    private String ruleUri = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public UserPresenceAlert name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the rule")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserPresenceAlert presenceUser(User presenceUser) {
        this.presenceUser = presenceUser;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user whose presence will be watched.")
    @JsonProperty(value="presenceUser")
    public User getPresenceUser() {
        return this.presenceUser;
    }

    public void setPresenceUser(User presenceUser) {
        this.presenceUser = presenceUser;
    }

    public UserPresenceAlert presenceType(PresenceTypeEnum presenceType) {
        this.presenceType = presenceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates to which presence type the presence value belongs.")
    @JsonProperty(value="presenceType")
    public PresenceTypeEnum getPresenceType() {
        return this.presenceType;
    }

    public void setPresenceType(PresenceTypeEnum presenceType) {
        this.presenceType = presenceType;
    }

    public UserPresenceAlert presenceValue(String presenceValue) {
        this.presenceValue = presenceValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Org's UUID or Systems enum constance indicating the presence of concern.")
    @JsonProperty(value="presenceValue")
    public String getPresenceValue() {
        return this.presenceValue;
    }

    public void setPresenceValue(String presenceValue) {
        this.presenceValue = presenceValue;
    }

    public UserPresenceAlert presenceLimitInSeconds(Integer presenceLimitInSeconds) {
        this.presenceLimitInSeconds = presenceLimitInSeconds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of seconds to wait before alerting based upon the user's presence.")
    @JsonProperty(value="presenceLimitInSeconds")
    public Integer getPresenceLimitInSeconds() {
        return this.presenceLimitInSeconds;
    }

    public void setPresenceLimitInSeconds(Integer presenceLimitInSeconds) {
        this.presenceLimitInSeconds = presenceLimitInSeconds;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the rule.")
    @JsonProperty(value="ruleId")
    public String getRuleId() {
        return this.ruleId;
    }

    @ApiModelProperty(example="null", required=true, value="The date/time the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @ApiModelProperty(example="null", value="The date/time the owning rule exiting in alarm status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public UserPresenceAlert notificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ids of users who were notified of alarm state change.")
    @JsonProperty(value="notificationUsers")
    public List<User> getNotificationUsers() {
        return this.notificationUsers;
    }

    public void setNotificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
    }

    public UserPresenceAlert alertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A collection of notification methods.")
    @JsonProperty(value="alertTypes")
    public List<AlertTypesEnum> getAlertTypes() {
        return this.alertTypes;
    }

    public void setAlertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
    }

    public UserPresenceAlert ruleUri(String ruleUri) {
        this.ruleUri = ruleUri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="ruleUri")
    public String getRuleUri() {
        return this.ruleUri;
    }

    public void setRuleUri(String ruleUri) {
        this.ruleUri = ruleUri;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPresenceAlert userPresenceAlert = (UserPresenceAlert)o;
        return Objects.equals(this.id, userPresenceAlert.id) && Objects.equals(this.name, userPresenceAlert.name) && Objects.equals(this.presenceUser, userPresenceAlert.presenceUser) && Objects.equals((Object)this.presenceType, (Object)userPresenceAlert.presenceType) && Objects.equals(this.presenceValue, userPresenceAlert.presenceValue) && Objects.equals(this.presenceLimitInSeconds, userPresenceAlert.presenceLimitInSeconds) && Objects.equals(this.ruleId, userPresenceAlert.ruleId) && Objects.equals(this.startDate, userPresenceAlert.startDate) && Objects.equals(this.endDate, userPresenceAlert.endDate) && Objects.equals(this.notificationUsers, userPresenceAlert.notificationUsers) && Objects.equals(this.alertTypes, userPresenceAlert.alertTypes) && Objects.equals(this.ruleUri, userPresenceAlert.ruleUri) && Objects.equals(this.selfUri, userPresenceAlert.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.presenceUser, this.presenceType, this.presenceValue, this.presenceLimitInSeconds, this.ruleId, this.startDate, this.endDate, this.notificationUsers, this.alertTypes, this.ruleUri, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPresenceAlert {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    presenceUser: ").append(this.toIndentedString(this.presenceUser)).append("\n");
        sb.append("    presenceType: ").append(this.toIndentedString((Object)this.presenceType)).append("\n");
        sb.append("    presenceValue: ").append(this.toIndentedString(this.presenceValue)).append("\n");
        sb.append("    presenceLimitInSeconds: ").append(this.toIndentedString(this.presenceLimitInSeconds)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    notificationUsers: ").append(this.toIndentedString(this.notificationUsers)).append("\n");
        sb.append("    alertTypes: ").append(this.toIndentedString(this.alertTypes)).append("\n");
        sb.append("    ruleUri: ").append(this.toIndentedString(this.ruleUri)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AlertTypesEnum {
        SMS("SMS"),
        DEVICE("DEVICE"),
        EMAIL("EMAIL");

        private String value;

        private AlertTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlertTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlertTypesEnum value : AlertTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlertTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum PresenceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SYSTEM("SYSTEM"),
        ORGANIZATION("ORGANIZATION");

        private String value;

        private PresenceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PresenceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PresenceTypeEnum value : PresenceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PresenceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

