/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Management Unit object for Workforce Management.")
public class ManagementUnit
implements Serializable {
    private String id = null;
    private String name = null;
    private StartDayOfWeekEnum startDayOfWeek = null;
    private String timezone = null;
    private Integer version = null;
    private Date dateModified = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ManagementUnit name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ManagementUnit startDayOfWeek(StartDayOfWeekEnum startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="Start day of week for workforce management planning purposes")
    @JsonProperty(value="startDayOfWeek")
    public StartDayOfWeekEnum getStartDayOfWeek() {
        return this.startDayOfWeek;
    }

    public void setStartDayOfWeek(StartDayOfWeekEnum startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
    }

    public ManagementUnit timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @ApiModelProperty(example="null", value="The time zone for the management unit in standard Olson Format (See https://en.wikipedia.org/wiki/Tz_database)")
    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public ManagementUnit version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the underlying ManagementUnit object. Useful for handling eventual consistency issues.  User must submit the current version they of the ManagementUnit in any write requests")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ManagementUnit dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time at which this management unit was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementUnit managementUnit = (ManagementUnit)o;
        return Objects.equals(this.id, managementUnit.id) && Objects.equals(this.name, managementUnit.name) && Objects.equals((Object)this.startDayOfWeek, (Object)managementUnit.startDayOfWeek) && Objects.equals(this.timezone, managementUnit.timezone) && Objects.equals(this.version, managementUnit.version) && Objects.equals(this.dateModified, managementUnit.dateModified) && Objects.equals(this.selfUri, managementUnit.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.startDayOfWeek, this.timezone, this.version, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagementUnit {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startDayOfWeek: ").append(this.toIndentedString((Object)this.startDayOfWeek)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StartDayOfWeekEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday"),
        SUNDAY("Sunday");

        private String value;

        private StartDayOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StartDayOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StartDayOfWeekEnum value : StartDayOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StartDayOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

