/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class TwitterIntegrationRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private String accessTokenKey = null;
    private String accessTokenSecret = null;
    private String consumerKey = null;
    private String consumerSecret = null;
    private TierEnum tier = null;
    private String envName = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public TwitterIntegrationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Twitter Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TwitterIntegrationRequest accessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Access Token Key from Twitter messenger")
    @JsonProperty(value="accessTokenKey")
    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public void setAccessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
    }

    public TwitterIntegrationRequest accessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Access Token Secret from Twitter messenger")
    @JsonProperty(value="accessTokenSecret")
    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public TwitterIntegrationRequest consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Consumer Key from Twitter messenger")
    @JsonProperty(value="consumerKey")
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public TwitterIntegrationRequest consumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Consumer Secret from Twitter messenger")
    @JsonProperty(value="consumerSecret")
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public TwitterIntegrationRequest tier(TierEnum tier) {
        this.tier = tier;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of twitter account to be used for the integration")
    @JsonProperty(value="tier")
    public TierEnum getTier() {
        return this.tier;
    }

    public void setTier(TierEnum tier) {
        this.tier = tier;
    }

    public TwitterIntegrationRequest envName(String envName) {
        this.envName = envName;
        return this;
    }

    @ApiModelProperty(example="null", value="The Twitter environment name, e.g.: env-beta (required for premium tier)")
    @JsonProperty(value="envName")
    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterIntegrationRequest twitterIntegrationRequest = (TwitterIntegrationRequest)o;
        return Objects.equals(this.id, twitterIntegrationRequest.id) && Objects.equals(this.name, twitterIntegrationRequest.name) && Objects.equals(this.accessTokenKey, twitterIntegrationRequest.accessTokenKey) && Objects.equals(this.accessTokenSecret, twitterIntegrationRequest.accessTokenSecret) && Objects.equals(this.consumerKey, twitterIntegrationRequest.consumerKey) && Objects.equals(this.consumerSecret, twitterIntegrationRequest.consumerSecret) && Objects.equals((Object)this.tier, (Object)twitterIntegrationRequest.tier) && Objects.equals(this.envName, twitterIntegrationRequest.envName) && Objects.equals(this.selfUri, twitterIntegrationRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.accessTokenKey, this.accessTokenSecret, this.consumerKey, this.consumerSecret, this.tier, this.envName, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwitterIntegrationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accessTokenKey: ").append(this.toIndentedString(this.accessTokenKey)).append("\n");
        sb.append("    accessTokenSecret: ").append(this.toIndentedString(this.accessTokenSecret)).append("\n");
        sb.append("    consumerKey: ").append(this.toIndentedString(this.consumerKey)).append("\n");
        sb.append("    consumerSecret: ").append(this.toIndentedString(this.consumerSecret)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString((Object)this.tier)).append("\n");
        sb.append("    envName: ").append(this.toIndentedString(this.envName)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TierEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PREMIUM("premium"),
        ENTERPRISE("enterprise");

        private String value;

        private TierEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TierEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TierEnum value : TierEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TierEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

