/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetScriptRequest {
    private String scriptId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public GetScriptRequest withScriptId(String scriptId) {
        this.setScriptId(scriptId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScriptRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.scriptId == null) {
            throw new IllegalStateException("Missing the required parameter 'scriptId' when building request for GetScriptRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scripts/{scriptId}").withPathParameter("scriptId", this.scriptId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scriptId) {
        return new Builder().withRequiredParams(scriptId);
    }

    public static class Builder {
        private final GetScriptRequest request = new GetScriptRequest();

        private Builder() {
        }

        public Builder withScriptId(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public Builder withRequiredParams(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public GetScriptRequest build() {
            if (this.request.scriptId == null) {
                throw new IllegalStateException("Missing the required parameter 'scriptId' when building request for GetScriptRequest.");
            }
            return this.request;
        }
    }
}

