/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ForecastGenerationResult;
import com.mypurecloud.sdk.v2.model.ListWrapperForecastSourceDayPointer;
import com.mypurecloud.sdk.v2.model.ListWrapperWfmForecastModification;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Short Term Forecast")
public class ShortTermForecast
implements Serializable {
    private String id = null;
    private String selfUri = null;
    private String weekDate = null;
    private String description = null;
    private CreationMethodEnum creationMethod = null;
    private WfmVersionedEntityMetadata metadata = null;
    private ListWrapperForecastSourceDayPointer sourceData = null;
    private Date referenceStartDate = null;
    private ListWrapperWfmForecastModification modifications = null;
    private ForecastGenerationResult generationResults = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public ShortTermForecast weekDate(String weekDate) {
        this.weekDate = weekDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The weekDate of the short term forecast in yyyy-MM-dd format")
    @JsonProperty(value="weekDate")
    public String getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(String weekDate) {
        this.weekDate = weekDate;
    }

    public ShortTermForecast description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the short term forecast")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="The method used to create this forecast")
    @JsonProperty(value="creationMethod")
    public CreationMethodEnum getCreationMethod() {
        return this.creationMethod;
    }

    public ShortTermForecast metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Metadata for this forecast")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public ShortTermForecast sourceData(ListWrapperForecastSourceDayPointer sourceData) {
        this.sourceData = sourceData;
        return this;
    }

    @ApiModelProperty(example="null", value="The source data references and metadata for this forecast")
    @JsonProperty(value="sourceData")
    public ListWrapperForecastSourceDayPointer getSourceData() {
        return this.sourceData;
    }

    public void setSourceData(ListWrapperForecastSourceDayPointer sourceData) {
        this.sourceData = sourceData;
    }

    @ApiModelProperty(example="null", value="ISO-8601 date that serves as the reference date for interval-based modifications")
    @JsonProperty(value="referenceStartDate")
    public Date getReferenceStartDate() {
        return this.referenceStartDate;
    }

    public ShortTermForecast modifications(ListWrapperWfmForecastModification modifications) {
        this.modifications = modifications;
        return this;
    }

    @ApiModelProperty(example="null", value="The modifications that have been applied to this forecast")
    @JsonProperty(value="modifications")
    public ListWrapperWfmForecastModification getModifications() {
        return this.modifications;
    }

    public void setModifications(ListWrapperWfmForecastModification modifications) {
        this.modifications = modifications;
    }

    public ShortTermForecast generationResults(ForecastGenerationResult generationResults) {
        this.generationResults = generationResults;
        return this;
    }

    @ApiModelProperty(example="null", value="Forecast generation results, if applicable")
    @JsonProperty(value="generationResults")
    public ForecastGenerationResult getGenerationResults() {
        return this.generationResults;
    }

    public void setGenerationResults(ForecastGenerationResult generationResults) {
        this.generationResults = generationResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortTermForecast shortTermForecast = (ShortTermForecast)o;
        return Objects.equals(this.id, shortTermForecast.id) && Objects.equals(this.selfUri, shortTermForecast.selfUri) && Objects.equals(this.weekDate, shortTermForecast.weekDate) && Objects.equals(this.description, shortTermForecast.description) && Objects.equals((Object)this.creationMethod, (Object)shortTermForecast.creationMethod) && Objects.equals(this.metadata, shortTermForecast.metadata) && Objects.equals(this.sourceData, shortTermForecast.sourceData) && Objects.equals(this.referenceStartDate, shortTermForecast.referenceStartDate) && Objects.equals(this.modifications, shortTermForecast.modifications) && Objects.equals(this.generationResults, shortTermForecast.generationResults);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.selfUri, this.weekDate, this.description, this.creationMethod, this.metadata, this.sourceData, this.referenceStartDate, this.modifications, this.generationResults});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShortTermForecast {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    weekDate: ").append(this.toIndentedString(this.weekDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    creationMethod: ").append(this.toIndentedString((Object)this.creationMethod)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    sourceData: ").append(this.toIndentedString(this.sourceData)).append("\n");
        sb.append("    referenceStartDate: ").append(this.toIndentedString(this.referenceStartDate)).append("\n");
        sb.append("    modifications: ").append(this.toIndentedString(this.modifications)).append("\n");
        sb.append("    generationResults: ").append(this.toIndentedString(this.generationResults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CreationMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IMPORT("Import"),
        HISTORICALWEIGHTEDAVERAGE("HistoricalWeightedAverage"),
        ADVANCED("Advanced");

        private String value;

        private CreationMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreationMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CreationMethodEnum value : CreationMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CreationMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

