/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetOutboundEventRequest {
    private String eventId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public GetOutboundEventRequest withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetOutboundEventRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.eventId == null) {
            throw new IllegalStateException("Missing the required parameter 'eventId' when building request for GetOutboundEventRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/outbound/events/{eventId}").withPathParameter("eventId", this.eventId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String eventId) {
        return new Builder().withRequiredParams(eventId);
    }

    public static class Builder {
        private final GetOutboundEventRequest request = new GetOutboundEventRequest();

        private Builder() {
        }

        public Builder withEventId(String eventId) {
            this.request.setEventId(eventId);
            return this;
        }

        public Builder withRequiredParams(String eventId) {
            this.request.setEventId(eventId);
            return this;
        }

        public GetOutboundEventRequest build() {
            if (this.request.eventId == null) {
                throw new IllegalStateException("Missing the required parameter 'eventId' when building request for GetOutboundEventRequest.");
            }
            return this.request;
        }
    }
}

