/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import com.mypurecloud.sdk.v2.model.ResponseSubstitution;
import com.mypurecloud.sdk.v2.model.ResponseText;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about a response.")
public class Response
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer version = null;
    private List<DomainEntityRef> libraries = new ArrayList<DomainEntityRef>();
    private List<ResponseText> texts = new ArrayList<ResponseText>();
    private User createdBy = null;
    private Date dateCreated = null;
    private InteractionTypeEnum interactionType = null;
    private List<ResponseSubstitution> substitutions = new ArrayList<ResponseSubstitution>();
    private JsonSchemaDocument substitutionsSchema = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Response name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Response version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Response libraries(List<DomainEntityRef> libraries) {
        this.libraries = libraries;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="One or more libraries response is associated with.")
    @JsonProperty(value="libraries")
    public List<DomainEntityRef> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<DomainEntityRef> libraries) {
        this.libraries = libraries;
    }

    public Response texts(List<ResponseText> texts) {
        this.texts = texts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="One or more texts associated with the response.")
    @JsonProperty(value="texts")
    public List<ResponseText> getTexts() {
        return this.texts;
    }

    public void setTexts(List<ResponseText> texts) {
        this.texts = texts;
    }

    public Response createdBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that created the response")
    @JsonProperty(value="createdBy")
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Response dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date and time the response was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Response interactionType(InteractionTypeEnum interactionType) {
        this.interactionType = interactionType;
        return this;
    }

    @ApiModelProperty(example="null", value="The interaction type for this response.")
    @JsonProperty(value="interactionType")
    public InteractionTypeEnum getInteractionType() {
        return this.interactionType;
    }

    public void setInteractionType(InteractionTypeEnum interactionType) {
        this.interactionType = interactionType;
    }

    public Response substitutions(List<ResponseSubstitution> substitutions) {
        this.substitutions = substitutions;
        return this;
    }

    @ApiModelProperty(example="null", value="Details about any text substitutions used in the texts for this response.")
    @JsonProperty(value="substitutions")
    public List<ResponseSubstitution> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(List<ResponseSubstitution> substitutions) {
        this.substitutions = substitutions;
    }

    public Response substitutionsSchema(JsonSchemaDocument substitutionsSchema) {
        this.substitutionsSchema = substitutionsSchema;
        return this;
    }

    @ApiModelProperty(example="null", value="Metadata about the text substitutions in json schema format.")
    @JsonProperty(value="substitutionsSchema")
    public JsonSchemaDocument getSubstitutionsSchema() {
        return this.substitutionsSchema;
    }

    public void setSubstitutionsSchema(JsonSchemaDocument substitutionsSchema) {
        this.substitutionsSchema = substitutionsSchema;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return Objects.equals(this.id, response.id) && Objects.equals(this.name, response.name) && Objects.equals(this.version, response.version) && Objects.equals(this.libraries, response.libraries) && Objects.equals(this.texts, response.texts) && Objects.equals(this.createdBy, response.createdBy) && Objects.equals(this.dateCreated, response.dateCreated) && Objects.equals((Object)this.interactionType, (Object)response.interactionType) && Objects.equals(this.substitutions, response.substitutions) && Objects.equals(this.substitutionsSchema, response.substitutionsSchema) && Objects.equals(this.selfUri, response.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.version, this.libraries, this.texts, this.createdBy, this.dateCreated, this.interactionType, this.substitutions, this.substitutionsSchema, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Response {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    libraries: ").append(this.toIndentedString(this.libraries)).append("\n");
        sb.append("    texts: ").append(this.toIndentedString(this.texts)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    interactionType: ").append(this.toIndentedString((Object)this.interactionType)).append("\n");
        sb.append("    substitutions: ").append(this.toIndentedString(this.substitutions)).append("\n");
        sb.append("    substitutionsSchema: ").append(this.toIndentedString(this.substitutionsSchema)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InteractionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CHAT("chat"),
        EMAIL("email"),
        TWITTER("twitter");

        private String value;

        private InteractionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InteractionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InteractionTypeEnum value : InteractionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InteractionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

