/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.LexBot;
import com.mypurecloud.sdk.v2.model.LexIntent;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LexBotAlias
implements Serializable {
    private String id = null;
    private String name = null;
    private LexBot bot = null;
    private String botVersion = null;
    private StatusEnum status = null;
    private String failureReason = null;
    private LanguageEnum language = null;
    private List<LexIntent> intents = new ArrayList<LexIntent>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LexBotAlias name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LexBotAlias bot(LexBot bot) {
        this.bot = bot;
        return this;
    }

    @ApiModelProperty(example="null", value="The Lex bot this is an alias for")
    @JsonProperty(value="bot")
    public LexBot getBot() {
        return this.bot;
    }

    public void setBot(LexBot bot) {
        this.bot = bot;
    }

    public LexBotAlias botVersion(String botVersion) {
        this.botVersion = botVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the Lex bot this alias points at")
    @JsonProperty(value="botVersion")
    public String getBotVersion() {
        return this.botVersion;
    }

    public void setBotVersion(String botVersion) {
        this.botVersion = botVersion;
    }

    public LexBotAlias status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the Lex bot alias")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public LexBotAlias failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @ApiModelProperty(example="null", value="If the status is FAILED, Amazon Lex explains why it failed to build the bot")
    @JsonProperty(value="failureReason")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public LexBotAlias language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The target language of the Lex bot")
    @JsonProperty(value="language")
    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public LexBotAlias intents(List<LexIntent> intents) {
        this.intents = intents;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of Intents associated with this bot alias")
    @JsonProperty(value="intents")
    public List<LexIntent> getIntents() {
        return this.intents;
    }

    public void setIntents(List<LexIntent> intents) {
        this.intents = intents;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexBotAlias lexBotAlias = (LexBotAlias)o;
        return Objects.equals(this.id, lexBotAlias.id) && Objects.equals(this.name, lexBotAlias.name) && Objects.equals(this.bot, lexBotAlias.bot) && Objects.equals(this.botVersion, lexBotAlias.botVersion) && Objects.equals((Object)this.status, (Object)lexBotAlias.status) && Objects.equals(this.failureReason, lexBotAlias.failureReason) && Objects.equals((Object)this.language, (Object)lexBotAlias.language) && Objects.equals(this.intents, lexBotAlias.intents) && Objects.equals(this.selfUri, lexBotAlias.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.bot, this.botVersion, this.status, this.failureReason, this.language, this.intents, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LexBotAlias {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    bot: ").append(this.toIndentedString(this.bot)).append("\n");
        sb.append("    botVersion: ").append(this.toIndentedString(this.botVersion)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LanguageEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_US("en-US");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageEnum value : LanguageEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BUILDING("BUILDING"),
        READY("READY"),
        FAILED("FAILED"),
        NOT_BUILT("NOT_BUILT");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

