/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetDateRequest;
import com.mypurecloud.sdk.v2.api.request.GetIprangesRequest;
import com.mypurecloud.sdk.v2.api.request.GetTimezonesRequest;
import com.mypurecloud.sdk.v2.api.request.PostCertificateDetailsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGmscTokensRequest;
import com.mypurecloud.sdk.v2.model.Certificate;
import com.mypurecloud.sdk.v2.model.IpAddressRangeListing;
import com.mypurecloud.sdk.v2.model.ParsedCertificate;
import com.mypurecloud.sdk.v2.model.ServerDate;
import com.mypurecloud.sdk.v2.model.TimeZoneEntityListing;
import com.mypurecloud.sdk.v2.model.Token;
import java.util.concurrent.Future;

public class UtilitiesApiAsync {
    private final ApiClient pcapiClient;

    public UtilitiesApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public UtilitiesApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<ServerDate> getDateAsync(GetDateRequest request, final AsyncApiCallback<ServerDate> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<ServerDate>(){}, new AsyncApiCallback<ApiResponse<ServerDate>>(){

                @Override
                public void onCompleted(ApiResponse<ServerDate> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        UtilitiesApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<ServerDate>> getDateAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<ServerDate>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<ServerDate>(){}, new AsyncApiCallback<ApiResponse<ServerDate>>(){

                @Override
                public void onCompleted(ApiResponse<ServerDate> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<IpAddressRangeListing> getIprangesAsync(GetIprangesRequest request, final AsyncApiCallback<IpAddressRangeListing> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<IpAddressRangeListing>(){}, new AsyncApiCallback<ApiResponse<IpAddressRangeListing>>(){

                @Override
                public void onCompleted(ApiResponse<IpAddressRangeListing> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        UtilitiesApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<IpAddressRangeListing>> getIprangesAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<IpAddressRangeListing>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<IpAddressRangeListing>(){}, new AsyncApiCallback<ApiResponse<IpAddressRangeListing>>(){

                @Override
                public void onCompleted(ApiResponse<IpAddressRangeListing> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<TimeZoneEntityListing> getTimezonesAsync(GetTimezonesRequest request, final AsyncApiCallback<TimeZoneEntityListing> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<TimeZoneEntityListing>(){}, new AsyncApiCallback<ApiResponse<TimeZoneEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<TimeZoneEntityListing> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        UtilitiesApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<TimeZoneEntityListing>> getTimezonesAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<TimeZoneEntityListing>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<TimeZoneEntityListing>(){}, new AsyncApiCallback<ApiResponse<TimeZoneEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<TimeZoneEntityListing> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ParsedCertificate> postCertificateDetailsAsync(PostCertificateDetailsRequest request, final AsyncApiCallback<ParsedCertificate> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<ParsedCertificate>(){}, new AsyncApiCallback<ApiResponse<ParsedCertificate>>(){

                @Override
                public void onCompleted(ApiResponse<ParsedCertificate> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        UtilitiesApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<ParsedCertificate>> postCertificateDetailsAsync(ApiRequest<Certificate> request, final AsyncApiCallback<ApiResponse<ParsedCertificate>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<ParsedCertificate>(){}, new AsyncApiCallback<ApiResponse<ParsedCertificate>>(){

                @Override
                public void onCompleted(ApiResponse<ParsedCertificate> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<Token> postGmscTokensAsync(PostGmscTokensRequest request, final AsyncApiCallback<Token> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Token>(){}, new AsyncApiCallback<ApiResponse<Token>>(){

                @Override
                public void onCompleted(ApiResponse<Token> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        UtilitiesApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Token>> postGmscTokensAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Token>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<Token>(){}, new AsyncApiCallback<ApiResponse<Token>>(){

                @Override
                public void onCompleted(ApiResponse<Token> response) {
                    UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        UtilitiesApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        UtilitiesApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

