/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.CreateWorkPlanShift;
import com.mypurecloud.sdk.v2.model.ListWrapperShiftStartVariance;
import com.mypurecloud.sdk.v2.model.SetWrapperDayOfWeek;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Work plan information")
public class CreateWorkPlan
implements Serializable {
    private String name = null;
    private Boolean enabled = null;
    private Boolean constrainWeeklyPaidTime = null;
    private Boolean flexibleWeeklyPaidTime = null;
    private Integer weeklyExactPaidMinutes = null;
    private Integer weeklyMinimumPaidMinutes = null;
    private Integer weeklyMaximumPaidMinutes = null;
    private Boolean constrainPaidTimeGranularity = null;
    private Integer paidTimeGranularityMinutes = null;
    private Boolean constrainMinimumTimeBetweenShifts = null;
    private Integer minimumTimeBetweenShiftsMinutes = null;
    private Integer maximumDays = null;
    private StartDayOfWeekendEnum startDayOfWeekend = null;
    private Integer minimumConsecutiveTimeOffPerWeekMinutes = null;
    private Boolean constrainMaximumConsecutiveWorkingWeekends = null;
    private Integer maximumConsecutiveWorkingWeekends = null;
    private Integer minimumWorkingDaysPerWeek = null;
    private Integer maximumConsecutiveWorkingDays = null;
    private Integer minimumShiftStartDistanceMinutes = null;
    private Integer minimumDaysOffPerPlanningPeriod = null;
    private Integer maximumDaysOffPerPlanningPeriod = null;
    private Integer minimumPaidHoursPerPlanningPeriod = null;
    private Integer maximumPaidHoursPerPlanningPeriod = null;
    private SetWrapperDayOfWeek optionalDays = null;
    private ListWrapperShiftStartVariance shiftStartVariances = null;
    private List<CreateWorkPlanShift> shifts = new ArrayList<CreateWorkPlanShift>();
    private List<UserReference> agents = new ArrayList<UserReference>();

    public CreateWorkPlan name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of this work plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateWorkPlan enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the work plan is enabled for scheduling")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CreateWorkPlan constrainWeeklyPaidTime(Boolean constrainWeeklyPaidTime) {
        this.constrainWeeklyPaidTime = constrainWeeklyPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the weekly paid time constraint is enabled for this work plan")
    @JsonProperty(value="constrainWeeklyPaidTime")
    public Boolean getConstrainWeeklyPaidTime() {
        return this.constrainWeeklyPaidTime;
    }

    public void setConstrainWeeklyPaidTime(Boolean constrainWeeklyPaidTime) {
        this.constrainWeeklyPaidTime = constrainWeeklyPaidTime;
    }

    public CreateWorkPlan flexibleWeeklyPaidTime(Boolean flexibleWeeklyPaidTime) {
        this.flexibleWeeklyPaidTime = flexibleWeeklyPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the weekly paid time constraint is flexible for this work plan")
    @JsonProperty(value="flexibleWeeklyPaidTime")
    public Boolean getFlexibleWeeklyPaidTime() {
        return this.flexibleWeeklyPaidTime;
    }

    public void setFlexibleWeeklyPaidTime(Boolean flexibleWeeklyPaidTime) {
        this.flexibleWeeklyPaidTime = flexibleWeeklyPaidTime;
    }

    public CreateWorkPlan weeklyExactPaidMinutes(Integer weeklyExactPaidMinutes) {
        this.weeklyExactPaidMinutes = weeklyExactPaidMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Exact weekly paid time in minutes for this work plan. Used if flexibleWeeklyPaidTime == false")
    @JsonProperty(value="weeklyExactPaidMinutes")
    public Integer getWeeklyExactPaidMinutes() {
        return this.weeklyExactPaidMinutes;
    }

    public void setWeeklyExactPaidMinutes(Integer weeklyExactPaidMinutes) {
        this.weeklyExactPaidMinutes = weeklyExactPaidMinutes;
    }

    public CreateWorkPlan weeklyMinimumPaidMinutes(Integer weeklyMinimumPaidMinutes) {
        this.weeklyMinimumPaidMinutes = weeklyMinimumPaidMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum weekly paid time in minutes for this work plan. Used if flexibleWeeklyPaidTime == true")
    @JsonProperty(value="weeklyMinimumPaidMinutes")
    public Integer getWeeklyMinimumPaidMinutes() {
        return this.weeklyMinimumPaidMinutes;
    }

    public void setWeeklyMinimumPaidMinutes(Integer weeklyMinimumPaidMinutes) {
        this.weeklyMinimumPaidMinutes = weeklyMinimumPaidMinutes;
    }

    public CreateWorkPlan weeklyMaximumPaidMinutes(Integer weeklyMaximumPaidMinutes) {
        this.weeklyMaximumPaidMinutes = weeklyMaximumPaidMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum weekly paid time in minutes for this work plan. Used if flexibleWeeklyPaidTime == true")
    @JsonProperty(value="weeklyMaximumPaidMinutes")
    public Integer getWeeklyMaximumPaidMinutes() {
        return this.weeklyMaximumPaidMinutes;
    }

    public void setWeeklyMaximumPaidMinutes(Integer weeklyMaximumPaidMinutes) {
        this.weeklyMaximumPaidMinutes = weeklyMaximumPaidMinutes;
    }

    public CreateWorkPlan constrainPaidTimeGranularity(Boolean constrainPaidTimeGranularity) {
        this.constrainPaidTimeGranularity = constrainPaidTimeGranularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether paid time granularity should be constrained for this workplan")
    @JsonProperty(value="constrainPaidTimeGranularity")
    public Boolean getConstrainPaidTimeGranularity() {
        return this.constrainPaidTimeGranularity;
    }

    public void setConstrainPaidTimeGranularity(Boolean constrainPaidTimeGranularity) {
        this.constrainPaidTimeGranularity = constrainPaidTimeGranularity;
    }

    public CreateWorkPlan paidTimeGranularityMinutes(Integer paidTimeGranularityMinutes) {
        this.paidTimeGranularityMinutes = paidTimeGranularityMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity in minutes allowed for shift paid time in this work plan. Used if constrainPaidTimeGranularity == true")
    @JsonProperty(value="paidTimeGranularityMinutes")
    public Integer getPaidTimeGranularityMinutes() {
        return this.paidTimeGranularityMinutes;
    }

    public void setPaidTimeGranularityMinutes(Integer paidTimeGranularityMinutes) {
        this.paidTimeGranularityMinutes = paidTimeGranularityMinutes;
    }

    public CreateWorkPlan constrainMinimumTimeBetweenShifts(Boolean constrainMinimumTimeBetweenShifts) {
        this.constrainMinimumTimeBetweenShifts = constrainMinimumTimeBetweenShifts;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the minimum time between shifts constraint is enabled for this work plan")
    @JsonProperty(value="constrainMinimumTimeBetweenShifts")
    public Boolean getConstrainMinimumTimeBetweenShifts() {
        return this.constrainMinimumTimeBetweenShifts;
    }

    public void setConstrainMinimumTimeBetweenShifts(Boolean constrainMinimumTimeBetweenShifts) {
        this.constrainMinimumTimeBetweenShifts = constrainMinimumTimeBetweenShifts;
    }

    public CreateWorkPlan minimumTimeBetweenShiftsMinutes(Integer minimumTimeBetweenShiftsMinutes) {
        this.minimumTimeBetweenShiftsMinutes = minimumTimeBetweenShiftsMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum time between shifts in minutes defined in this work plan. Used if constrainMinimumTimeBetweenShifts == true")
    @JsonProperty(value="minimumTimeBetweenShiftsMinutes")
    public Integer getMinimumTimeBetweenShiftsMinutes() {
        return this.minimumTimeBetweenShiftsMinutes;
    }

    public void setMinimumTimeBetweenShiftsMinutes(Integer minimumTimeBetweenShiftsMinutes) {
        this.minimumTimeBetweenShiftsMinutes = minimumTimeBetweenShiftsMinutes;
    }

    public CreateWorkPlan maximumDays(Integer maximumDays) {
        this.maximumDays = maximumDays;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum number days in a week allowed to be scheduled for this work plan")
    @JsonProperty(value="maximumDays")
    public Integer getMaximumDays() {
        return this.maximumDays;
    }

    public void setMaximumDays(Integer maximumDays) {
        this.maximumDays = maximumDays;
    }

    public CreateWorkPlan startDayOfWeekend(StartDayOfWeekendEnum startDayOfWeekend) {
        this.startDayOfWeekend = startDayOfWeekend;
        return this;
    }

    @ApiModelProperty(example="null", value="The day of the week for which the weekend starts, such as Saturday")
    @JsonProperty(value="startDayOfWeekend")
    public StartDayOfWeekendEnum getStartDayOfWeekend() {
        return this.startDayOfWeekend;
    }

    public void setStartDayOfWeekend(StartDayOfWeekendEnum startDayOfWeekend) {
        this.startDayOfWeekend = startDayOfWeekend;
    }

    public CreateWorkPlan minimumConsecutiveTimeOffPerWeekMinutes(Integer minimumConsecutiveTimeOffPerWeekMinutes) {
        this.minimumConsecutiveTimeOffPerWeekMinutes = minimumConsecutiveTimeOffPerWeekMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum amount of consecutive time off per week that agents who are assigned this work plan are allowed to have off")
    @JsonProperty(value="minimumConsecutiveTimeOffPerWeekMinutes")
    public Integer getMinimumConsecutiveTimeOffPerWeekMinutes() {
        return this.minimumConsecutiveTimeOffPerWeekMinutes;
    }

    public void setMinimumConsecutiveTimeOffPerWeekMinutes(Integer minimumConsecutiveTimeOffPerWeekMinutes) {
        this.minimumConsecutiveTimeOffPerWeekMinutes = minimumConsecutiveTimeOffPerWeekMinutes;
    }

    public CreateWorkPlan constrainMaximumConsecutiveWorkingWeekends(Boolean constrainMaximumConsecutiveWorkingWeekends) {
        this.constrainMaximumConsecutiveWorkingWeekends = constrainMaximumConsecutiveWorkingWeekends;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to constrain the maximum consecutive working weekends")
    @JsonProperty(value="constrainMaximumConsecutiveWorkingWeekends")
    public Boolean getConstrainMaximumConsecutiveWorkingWeekends() {
        return this.constrainMaximumConsecutiveWorkingWeekends;
    }

    public void setConstrainMaximumConsecutiveWorkingWeekends(Boolean constrainMaximumConsecutiveWorkingWeekends) {
        this.constrainMaximumConsecutiveWorkingWeekends = constrainMaximumConsecutiveWorkingWeekends;
    }

    public CreateWorkPlan maximumConsecutiveWorkingWeekends(Integer maximumConsecutiveWorkingWeekends) {
        this.maximumConsecutiveWorkingWeekends = maximumConsecutiveWorkingWeekends;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of consecutive weekends that agents who are assigned to this work plan are allowed to work")
    @JsonProperty(value="maximumConsecutiveWorkingWeekends")
    public Integer getMaximumConsecutiveWorkingWeekends() {
        return this.maximumConsecutiveWorkingWeekends;
    }

    public void setMaximumConsecutiveWorkingWeekends(Integer maximumConsecutiveWorkingWeekends) {
        this.maximumConsecutiveWorkingWeekends = maximumConsecutiveWorkingWeekends;
    }

    public CreateWorkPlan minimumWorkingDaysPerWeek(Integer minimumWorkingDaysPerWeek) {
        this.minimumWorkingDaysPerWeek = minimumWorkingDaysPerWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="The minimum number of days that agents assigned to a work plan must work per week")
    @JsonProperty(value="minimumWorkingDaysPerWeek")
    public Integer getMinimumWorkingDaysPerWeek() {
        return this.minimumWorkingDaysPerWeek;
    }

    public void setMinimumWorkingDaysPerWeek(Integer minimumWorkingDaysPerWeek) {
        this.minimumWorkingDaysPerWeek = minimumWorkingDaysPerWeek;
    }

    public CreateWorkPlan maximumConsecutiveWorkingDays(Integer maximumConsecutiveWorkingDays) {
        this.maximumConsecutiveWorkingDays = maximumConsecutiveWorkingDays;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of consecutive days that agents assigned to this work plan are allowed to work")
    @JsonProperty(value="maximumConsecutiveWorkingDays")
    public Integer getMaximumConsecutiveWorkingDays() {
        return this.maximumConsecutiveWorkingDays;
    }

    public void setMaximumConsecutiveWorkingDays(Integer maximumConsecutiveWorkingDays) {
        this.maximumConsecutiveWorkingDays = maximumConsecutiveWorkingDays;
    }

    public CreateWorkPlan minimumShiftStartDistanceMinutes(Integer minimumShiftStartDistanceMinutes) {
        this.minimumShiftStartDistanceMinutes = minimumShiftStartDistanceMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The time period in minutes for the duration between the start times of two consecutive working days")
    @JsonProperty(value="minimumShiftStartDistanceMinutes")
    public Integer getMinimumShiftStartDistanceMinutes() {
        return this.minimumShiftStartDistanceMinutes;
    }

    public void setMinimumShiftStartDistanceMinutes(Integer minimumShiftStartDistanceMinutes) {
        this.minimumShiftStartDistanceMinutes = minimumShiftStartDistanceMinutes;
    }

    public CreateWorkPlan minimumDaysOffPerPlanningPeriod(Integer minimumDaysOffPerPlanningPeriod) {
        this.minimumDaysOffPerPlanningPeriod = minimumDaysOffPerPlanningPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum days off in the planning period")
    @JsonProperty(value="minimumDaysOffPerPlanningPeriod")
    public Integer getMinimumDaysOffPerPlanningPeriod() {
        return this.minimumDaysOffPerPlanningPeriod;
    }

    public void setMinimumDaysOffPerPlanningPeriod(Integer minimumDaysOffPerPlanningPeriod) {
        this.minimumDaysOffPerPlanningPeriod = minimumDaysOffPerPlanningPeriod;
    }

    public CreateWorkPlan maximumDaysOffPerPlanningPeriod(Integer maximumDaysOffPerPlanningPeriod) {
        this.maximumDaysOffPerPlanningPeriod = maximumDaysOffPerPlanningPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum days off in the planning period")
    @JsonProperty(value="maximumDaysOffPerPlanningPeriod")
    public Integer getMaximumDaysOffPerPlanningPeriod() {
        return this.maximumDaysOffPerPlanningPeriod;
    }

    public void setMaximumDaysOffPerPlanningPeriod(Integer maximumDaysOffPerPlanningPeriod) {
        this.maximumDaysOffPerPlanningPeriod = maximumDaysOffPerPlanningPeriod;
    }

    public CreateWorkPlan minimumPaidHoursPerPlanningPeriod(Integer minimumPaidHoursPerPlanningPeriod) {
        this.minimumPaidHoursPerPlanningPeriod = minimumPaidHoursPerPlanningPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum paid hours in the planning period")
    @JsonProperty(value="minimumPaidHoursPerPlanningPeriod")
    public Integer getMinimumPaidHoursPerPlanningPeriod() {
        return this.minimumPaidHoursPerPlanningPeriod;
    }

    public void setMinimumPaidHoursPerPlanningPeriod(Integer minimumPaidHoursPerPlanningPeriod) {
        this.minimumPaidHoursPerPlanningPeriod = minimumPaidHoursPerPlanningPeriod;
    }

    public CreateWorkPlan maximumPaidHoursPerPlanningPeriod(Integer maximumPaidHoursPerPlanningPeriod) {
        this.maximumPaidHoursPerPlanningPeriod = maximumPaidHoursPerPlanningPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum paid hours in the planning period")
    @JsonProperty(value="maximumPaidHoursPerPlanningPeriod")
    public Integer getMaximumPaidHoursPerPlanningPeriod() {
        return this.maximumPaidHoursPerPlanningPeriod;
    }

    public void setMaximumPaidHoursPerPlanningPeriod(Integer maximumPaidHoursPerPlanningPeriod) {
        this.maximumPaidHoursPerPlanningPeriod = maximumPaidHoursPerPlanningPeriod;
    }

    public CreateWorkPlan optionalDays(SetWrapperDayOfWeek optionalDays) {
        this.optionalDays = optionalDays;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional days to schedule for this work plan")
    @JsonProperty(value="optionalDays")
    public SetWrapperDayOfWeek getOptionalDays() {
        return this.optionalDays;
    }

    public void setOptionalDays(SetWrapperDayOfWeek optionalDays) {
        this.optionalDays = optionalDays;
    }

    public CreateWorkPlan shiftStartVariances(ListWrapperShiftStartVariance shiftStartVariances) {
        this.shiftStartVariances = shiftStartVariances;
        return this;
    }

    @ApiModelProperty(example="null", value="Variance in minutes among start times of shifts in this work plan")
    @JsonProperty(value="shiftStartVariances")
    public ListWrapperShiftStartVariance getShiftStartVariances() {
        return this.shiftStartVariances;
    }

    public void setShiftStartVariances(ListWrapperShiftStartVariance shiftStartVariances) {
        this.shiftStartVariances = shiftStartVariances;
    }

    public CreateWorkPlan shifts(List<CreateWorkPlanShift> shifts) {
        this.shifts = shifts;
        return this;
    }

    @ApiModelProperty(example="null", value="Shifts in this work plan")
    @JsonProperty(value="shifts")
    public List<CreateWorkPlanShift> getShifts() {
        return this.shifts;
    }

    public void setShifts(List<CreateWorkPlanShift> shifts) {
        this.shifts = shifts;
    }

    public CreateWorkPlan agents(List<UserReference> agents) {
        this.agents = agents;
        return this;
    }

    @ApiModelProperty(example="null", value="Agents in this work plan")
    @JsonProperty(value="agents")
    public List<UserReference> getAgents() {
        return this.agents;
    }

    public void setAgents(List<UserReference> agents) {
        this.agents = agents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWorkPlan createWorkPlan = (CreateWorkPlan)o;
        return Objects.equals(this.name, createWorkPlan.name) && Objects.equals(this.enabled, createWorkPlan.enabled) && Objects.equals(this.constrainWeeklyPaidTime, createWorkPlan.constrainWeeklyPaidTime) && Objects.equals(this.flexibleWeeklyPaidTime, createWorkPlan.flexibleWeeklyPaidTime) && Objects.equals(this.weeklyExactPaidMinutes, createWorkPlan.weeklyExactPaidMinutes) && Objects.equals(this.weeklyMinimumPaidMinutes, createWorkPlan.weeklyMinimumPaidMinutes) && Objects.equals(this.weeklyMaximumPaidMinutes, createWorkPlan.weeklyMaximumPaidMinutes) && Objects.equals(this.constrainPaidTimeGranularity, createWorkPlan.constrainPaidTimeGranularity) && Objects.equals(this.paidTimeGranularityMinutes, createWorkPlan.paidTimeGranularityMinutes) && Objects.equals(this.constrainMinimumTimeBetweenShifts, createWorkPlan.constrainMinimumTimeBetweenShifts) && Objects.equals(this.minimumTimeBetweenShiftsMinutes, createWorkPlan.minimumTimeBetweenShiftsMinutes) && Objects.equals(this.maximumDays, createWorkPlan.maximumDays) && Objects.equals((Object)this.startDayOfWeekend, (Object)createWorkPlan.startDayOfWeekend) && Objects.equals(this.minimumConsecutiveTimeOffPerWeekMinutes, createWorkPlan.minimumConsecutiveTimeOffPerWeekMinutes) && Objects.equals(this.constrainMaximumConsecutiveWorkingWeekends, createWorkPlan.constrainMaximumConsecutiveWorkingWeekends) && Objects.equals(this.maximumConsecutiveWorkingWeekends, createWorkPlan.maximumConsecutiveWorkingWeekends) && Objects.equals(this.minimumWorkingDaysPerWeek, createWorkPlan.minimumWorkingDaysPerWeek) && Objects.equals(this.maximumConsecutiveWorkingDays, createWorkPlan.maximumConsecutiveWorkingDays) && Objects.equals(this.minimumShiftStartDistanceMinutes, createWorkPlan.minimumShiftStartDistanceMinutes) && Objects.equals(this.minimumDaysOffPerPlanningPeriod, createWorkPlan.minimumDaysOffPerPlanningPeriod) && Objects.equals(this.maximumDaysOffPerPlanningPeriod, createWorkPlan.maximumDaysOffPerPlanningPeriod) && Objects.equals(this.minimumPaidHoursPerPlanningPeriod, createWorkPlan.minimumPaidHoursPerPlanningPeriod) && Objects.equals(this.maximumPaidHoursPerPlanningPeriod, createWorkPlan.maximumPaidHoursPerPlanningPeriod) && Objects.equals(this.optionalDays, createWorkPlan.optionalDays) && Objects.equals(this.shiftStartVariances, createWorkPlan.shiftStartVariances) && Objects.equals(this.shifts, createWorkPlan.shifts) && Objects.equals(this.agents, createWorkPlan.agents);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.enabled, this.constrainWeeklyPaidTime, this.flexibleWeeklyPaidTime, this.weeklyExactPaidMinutes, this.weeklyMinimumPaidMinutes, this.weeklyMaximumPaidMinutes, this.constrainPaidTimeGranularity, this.paidTimeGranularityMinutes, this.constrainMinimumTimeBetweenShifts, this.minimumTimeBetweenShiftsMinutes, this.maximumDays, this.startDayOfWeekend, this.minimumConsecutiveTimeOffPerWeekMinutes, this.constrainMaximumConsecutiveWorkingWeekends, this.maximumConsecutiveWorkingWeekends, this.minimumWorkingDaysPerWeek, this.maximumConsecutiveWorkingDays, this.minimumShiftStartDistanceMinutes, this.minimumDaysOffPerPlanningPeriod, this.maximumDaysOffPerPlanningPeriod, this.minimumPaidHoursPerPlanningPeriod, this.maximumPaidHoursPerPlanningPeriod, this.optionalDays, this.shiftStartVariances, this.shifts, this.agents});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWorkPlan {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    constrainWeeklyPaidTime: ").append(this.toIndentedString(this.constrainWeeklyPaidTime)).append("\n");
        sb.append("    flexibleWeeklyPaidTime: ").append(this.toIndentedString(this.flexibleWeeklyPaidTime)).append("\n");
        sb.append("    weeklyExactPaidMinutes: ").append(this.toIndentedString(this.weeklyExactPaidMinutes)).append("\n");
        sb.append("    weeklyMinimumPaidMinutes: ").append(this.toIndentedString(this.weeklyMinimumPaidMinutes)).append("\n");
        sb.append("    weeklyMaximumPaidMinutes: ").append(this.toIndentedString(this.weeklyMaximumPaidMinutes)).append("\n");
        sb.append("    constrainPaidTimeGranularity: ").append(this.toIndentedString(this.constrainPaidTimeGranularity)).append("\n");
        sb.append("    paidTimeGranularityMinutes: ").append(this.toIndentedString(this.paidTimeGranularityMinutes)).append("\n");
        sb.append("    constrainMinimumTimeBetweenShifts: ").append(this.toIndentedString(this.constrainMinimumTimeBetweenShifts)).append("\n");
        sb.append("    minimumTimeBetweenShiftsMinutes: ").append(this.toIndentedString(this.minimumTimeBetweenShiftsMinutes)).append("\n");
        sb.append("    maximumDays: ").append(this.toIndentedString(this.maximumDays)).append("\n");
        sb.append("    startDayOfWeekend: ").append(this.toIndentedString((Object)this.startDayOfWeekend)).append("\n");
        sb.append("    minimumConsecutiveTimeOffPerWeekMinutes: ").append(this.toIndentedString(this.minimumConsecutiveTimeOffPerWeekMinutes)).append("\n");
        sb.append("    constrainMaximumConsecutiveWorkingWeekends: ").append(this.toIndentedString(this.constrainMaximumConsecutiveWorkingWeekends)).append("\n");
        sb.append("    maximumConsecutiveWorkingWeekends: ").append(this.toIndentedString(this.maximumConsecutiveWorkingWeekends)).append("\n");
        sb.append("    minimumWorkingDaysPerWeek: ").append(this.toIndentedString(this.minimumWorkingDaysPerWeek)).append("\n");
        sb.append("    maximumConsecutiveWorkingDays: ").append(this.toIndentedString(this.maximumConsecutiveWorkingDays)).append("\n");
        sb.append("    minimumShiftStartDistanceMinutes: ").append(this.toIndentedString(this.minimumShiftStartDistanceMinutes)).append("\n");
        sb.append("    minimumDaysOffPerPlanningPeriod: ").append(this.toIndentedString(this.minimumDaysOffPerPlanningPeriod)).append("\n");
        sb.append("    maximumDaysOffPerPlanningPeriod: ").append(this.toIndentedString(this.maximumDaysOffPerPlanningPeriod)).append("\n");
        sb.append("    minimumPaidHoursPerPlanningPeriod: ").append(this.toIndentedString(this.minimumPaidHoursPerPlanningPeriod)).append("\n");
        sb.append("    maximumPaidHoursPerPlanningPeriod: ").append(this.toIndentedString(this.maximumPaidHoursPerPlanningPeriod)).append("\n");
        sb.append("    optionalDays: ").append(this.toIndentedString(this.optionalDays)).append("\n");
        sb.append("    shiftStartVariances: ").append(this.toIndentedString(this.shiftStartVariances)).append("\n");
        sb.append("    shifts: ").append(this.toIndentedString(this.shifts)).append("\n");
        sb.append("    agents: ").append(this.toIndentedString(this.agents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StartDayOfWeekendEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private StartDayOfWeekendEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StartDayOfWeekendEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StartDayOfWeekendEnum value : StartDayOfWeekendEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StartDayOfWeekendEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

