/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteLocationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationSublocationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PatchLocationRequest;
import com.mypurecloud.sdk.v2.api.request.PostLocationsRequest;
import com.mypurecloud.sdk.v2.api.request.PostLocationsSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationCreateUpdateDefinition;
import com.mypurecloud.sdk.v2.model.LocationDefinition;
import com.mypurecloud.sdk.v2.model.LocationEntityListing;
import com.mypurecloud.sdk.v2.model.LocationSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationsSearchResponse;
import java.io.IOException;
import java.util.List;

public class LocationsApi {
    private final ApiClient pcapiClient;

    public LocationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LocationsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteLocation(String locationId) throws IOException, ApiException {
        this.deleteLocation(this.createDeleteLocationRequest(locationId));
    }

    public ApiResponse<Void> deleteLocationWithHttpInfo(String locationId) throws IOException {
        return this.deleteLocation(this.createDeleteLocationRequest(locationId).withHttpInfo());
    }

    private DeleteLocationRequest createDeleteLocationRequest(String locationId) {
        return DeleteLocationRequest.builder().withLocationId(locationId).build();
    }

    public void deleteLocation(DeleteLocationRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteLocation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationDefinition getLocation(String locationId, List<String> expand) throws IOException, ApiException {
        return this.getLocation(this.createGetLocationRequest(locationId, expand));
    }

    public ApiResponse<LocationDefinition> getLocationWithHttpInfo(String locationId, List<String> expand) throws IOException {
        return this.getLocation(this.createGetLocationRequest(locationId, expand).withHttpInfo());
    }

    private GetLocationRequest createGetLocationRequest(String locationId, List<String> expand) {
        return GetLocationRequest.builder().withLocationId(locationId).withExpand(expand).build();
    }

    public LocationDefinition getLocation(GetLocationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationDefinition> getLocation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationEntityListing getLocationSublocations(String locationId) throws IOException, ApiException {
        return this.getLocationSublocations(this.createGetLocationSublocationsRequest(locationId));
    }

    public ApiResponse<LocationEntityListing> getLocationSublocationsWithHttpInfo(String locationId) throws IOException {
        return this.getLocationSublocations(this.createGetLocationSublocationsRequest(locationId).withHttpInfo());
    }

    private GetLocationSublocationsRequest createGetLocationSublocationsRequest(String locationId) {
        return GetLocationSublocationsRequest.builder().withLocationId(locationId).build();
    }

    public LocationEntityListing getLocationSublocations(GetLocationSublocationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationEntityListing> getLocationSublocations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationEntityListing getLocations(Integer pageSize, Integer pageNumber, List<String> id, String sortOrder) throws IOException, ApiException {
        return this.getLocations(this.createGetLocationsRequest(pageSize, pageNumber, id, sortOrder));
    }

    public ApiResponse<LocationEntityListing> getLocationsWithHttpInfo(Integer pageSize, Integer pageNumber, List<String> id, String sortOrder) throws IOException {
        return this.getLocations(this.createGetLocationsRequest(pageSize, pageNumber, id, sortOrder).withHttpInfo());
    }

    private GetLocationsRequest createGetLocationsRequest(Integer pageSize, Integer pageNumber, List<String> id, String sortOrder) {
        return GetLocationsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withId(id).withSortOrder(sortOrder).build();
    }

    public LocationEntityListing getLocations(GetLocationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationEntityListing> getLocations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationsSearchResponse getLocationsSearch(String q64, List<String> expand) throws IOException, ApiException {
        return this.getLocationsSearch(this.createGetLocationsSearchRequest(q64, expand));
    }

    public ApiResponse<LocationsSearchResponse> getLocationsSearchWithHttpInfo(String q64, List<String> expand) throws IOException {
        return this.getLocationsSearch(this.createGetLocationsSearchRequest(q64, expand).withHttpInfo());
    }

    private GetLocationsSearchRequest createGetLocationsSearchRequest(String q64, List<String> expand) {
        return GetLocationsSearchRequest.builder().withQ64(q64).withExpand(expand).build();
    }

    public LocationsSearchResponse getLocationsSearch(GetLocationsSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationsSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationsSearchResponse> getLocationsSearch(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationsSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationDefinition patchLocation(String locationId, LocationCreateUpdateDefinition body) throws IOException, ApiException {
        return this.patchLocation(this.createPatchLocationRequest(locationId, body));
    }

    public ApiResponse<LocationDefinition> patchLocationWithHttpInfo(String locationId, LocationCreateUpdateDefinition body) throws IOException {
        return this.patchLocation(this.createPatchLocationRequest(locationId, body).withHttpInfo());
    }

    private PatchLocationRequest createPatchLocationRequest(String locationId, LocationCreateUpdateDefinition body) {
        return PatchLocationRequest.builder().withLocationId(locationId).withBody(body).build();
    }

    public LocationDefinition patchLocation(PatchLocationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationDefinition> patchLocation(ApiRequest<LocationCreateUpdateDefinition> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationDefinition postLocations(LocationCreateUpdateDefinition body) throws IOException, ApiException {
        return this.postLocations(this.createPostLocationsRequest(body));
    }

    public ApiResponse<LocationDefinition> postLocationsWithHttpInfo(LocationCreateUpdateDefinition body) throws IOException {
        return this.postLocations(this.createPostLocationsRequest(body).withHttpInfo());
    }

    private PostLocationsRequest createPostLocationsRequest(LocationCreateUpdateDefinition body) {
        return PostLocationsRequest.builder().withBody(body).build();
    }

    public LocationDefinition postLocations(PostLocationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationDefinition> postLocations(ApiRequest<LocationCreateUpdateDefinition> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationsSearchResponse postLocationsSearch(LocationSearchRequest body) throws IOException, ApiException {
        return this.postLocationsSearch(this.createPostLocationsSearchRequest(body));
    }

    public ApiResponse<LocationsSearchResponse> postLocationsSearchWithHttpInfo(LocationSearchRequest body) throws IOException {
        return this.postLocationsSearch(this.createPostLocationsSearchRequest(body).withHttpInfo());
    }

    private PostLocationsSearchRequest createPostLocationsSearchRequest(LocationSearchRequest body) {
        return PostLocationsSearchRequest.builder().withBody(body).build();
    }

    public LocationsSearchResponse postLocationsSearch(PostLocationsSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationsSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationsSearchResponse> postLocationsSearch(ApiRequest<LocationSearchRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationsSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

