/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ScimMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="SCIM Group Reference")
public class ScimV2GroupReference
implements Serializable {
    private ScimMetadata meta = null;
    private TypeEnum type = null;
    private String value = null;
    private String ref = null;

    public ScimV2GroupReference meta(ScimMetadata meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(example="null", value="Resource SCIM meta")
    @JsonProperty(value="meta")
    public ScimMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(ScimMetadata meta) {
        this.meta = meta;
    }

    @ApiModelProperty(example="null", value="SCIM Resource Type of member")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public ScimV2GroupReference value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the group member. Can be userId or groupId.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ApiModelProperty(example="null", value="Ref to entity")
    @JsonProperty(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2GroupReference scimV2GroupReference = (ScimV2GroupReference)o;
        return Objects.equals(this.meta, scimV2GroupReference.meta) && Objects.equals((Object)this.type, (Object)scimV2GroupReference.type) && Objects.equals(this.value, scimV2GroupReference.value) && Objects.equals(this.ref, scimV2GroupReference.ref);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.meta, this.type, this.value, this.ref});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2GroupReference {\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    ref: ").append(this.toIndentedString(this.ref)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("User"),
        GROUP("Group"),
        SERVICEPROVIDERCONFIG("ServiceProviderConfig");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

