/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ShiftTradeResponseAcceptableIntervals;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class UpdateShiftTradeRequest
implements Serializable {
    private String receivingUserId = null;
    private Date expiration = null;
    private List<ShiftTradeResponseAcceptableIntervals> acceptableIntervals = new ArrayList<ShiftTradeResponseAcceptableIntervals>();
    private WfmVersionedEntityMetadata metadata = null;

    public UpdateShiftTradeRequest receivingUserId(String receivingUserId) {
        this.receivingUserId = receivingUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="Update the ID of the receiving user to direct the request at a specific user, or set to null to open up a trade to be matched by any user")
    @JsonProperty(value="receivingUserId")
    public String getReceivingUserId() {
        return this.receivingUserId;
    }

    public void setReceivingUserId(String receivingUserId) {
        this.receivingUserId = receivingUserId;
    }

    public UpdateShiftTradeRequest expiration(Date expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(example="null", value="Update the expiration time for this shift trade. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public UpdateShiftTradeRequest acceptableIntervals(List<ShiftTradeResponseAcceptableIntervals> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="acceptableIntervals")
    public List<ShiftTradeResponseAcceptableIntervals> getAcceptableIntervals() {
        return this.acceptableIntervals;
    }

    public void setAcceptableIntervals(List<ShiftTradeResponseAcceptableIntervals> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
    }

    public UpdateShiftTradeRequest metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateShiftTradeRequest updateShiftTradeRequest = (UpdateShiftTradeRequest)o;
        return Objects.equals(this.receivingUserId, updateShiftTradeRequest.receivingUserId) && Objects.equals(this.expiration, updateShiftTradeRequest.expiration) && Objects.equals(this.acceptableIntervals, updateShiftTradeRequest.acceptableIntervals) && Objects.equals(this.metadata, updateShiftTradeRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.receivingUserId, this.expiration, this.acceptableIntervals, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateShiftTradeRequest {\n");
        sb.append("    receivingUserId: ").append(this.toIndentedString(this.receivingUserId)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    acceptableIntervals: ").append(this.toIndentedString(this.acceptableIntervals)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

