/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AnalyticsEvaluation;
import com.mypurecloud.sdk.v2.model.AnalyticsParticipant;
import com.mypurecloud.sdk.v2.model.AnalyticsSurvey;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AnalyticsConversation
implements Serializable {
    private String conversationId = null;
    private Date conversationStart = null;
    private Date conversationEnd = null;
    private Double mediaStatsMinConversationMos = null;
    private Double mediaStatsMinConversationRFactor = null;
    private OriginatingDirectionEnum originatingDirection = null;
    private List<AnalyticsParticipant> participants = new ArrayList<AnalyticsParticipant>();
    private List<AnalyticsEvaluation> evaluations = new ArrayList<AnalyticsEvaluation>();
    private List<AnalyticsSurvey> surveys = new ArrayList<AnalyticsSurvey>();
    private List<String> divisionIds = new ArrayList<String>();

    public AnalyticsConversation conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public AnalyticsConversation conversationStart(Date conversationStart) {
        this.conversationStart = conversationStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Date/time the conversation started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="conversationStart")
    public Date getConversationStart() {
        return this.conversationStart;
    }

    public void setConversationStart(Date conversationStart) {
        this.conversationStart = conversationStart;
    }

    public AnalyticsConversation conversationEnd(Date conversationEnd) {
        this.conversationEnd = conversationEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="Date/time the conversation ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="conversationEnd")
    public Date getConversationEnd() {
        return this.conversationEnd;
    }

    public void setConversationEnd(Date conversationEnd) {
        this.conversationEnd = conversationEnd;
    }

    public AnalyticsConversation mediaStatsMinConversationMos(Double mediaStatsMinConversationMos) {
        this.mediaStatsMinConversationMos = mediaStatsMinConversationMos;
        return this;
    }

    @ApiModelProperty(example="null", value="The lowest estimated average MOS among all the audio streams belonging to this conversation")
    @JsonProperty(value="mediaStatsMinConversationMos")
    public Double getMediaStatsMinConversationMos() {
        return this.mediaStatsMinConversationMos;
    }

    public void setMediaStatsMinConversationMos(Double mediaStatsMinConversationMos) {
        this.mediaStatsMinConversationMos = mediaStatsMinConversationMos;
    }

    public AnalyticsConversation mediaStatsMinConversationRFactor(Double mediaStatsMinConversationRFactor) {
        this.mediaStatsMinConversationRFactor = mediaStatsMinConversationRFactor;
        return this;
    }

    @ApiModelProperty(example="null", value="The lowest R-factor value among all of the audio streams belonging to this conversation")
    @JsonProperty(value="mediaStatsMinConversationRFactor")
    public Double getMediaStatsMinConversationRFactor() {
        return this.mediaStatsMinConversationRFactor;
    }

    public void setMediaStatsMinConversationRFactor(Double mediaStatsMinConversationRFactor) {
        this.mediaStatsMinConversationRFactor = mediaStatsMinConversationRFactor;
    }

    public AnalyticsConversation originatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
        return this;
    }

    @ApiModelProperty(example="null", value="The original direction of the conversation")
    @JsonProperty(value="originatingDirection")
    public OriginatingDirectionEnum getOriginatingDirection() {
        return this.originatingDirection;
    }

    public void setOriginatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
    }

    public AnalyticsConversation participants(List<AnalyticsParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="Participants in the conversation")
    @JsonProperty(value="participants")
    public List<AnalyticsParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<AnalyticsParticipant> participants) {
        this.participants = participants;
    }

    public AnalyticsConversation evaluations(List<AnalyticsEvaluation> evaluations) {
        this.evaluations = evaluations;
        return this;
    }

    @ApiModelProperty(example="null", value="Evaluations tied to this conversation")
    @JsonProperty(value="evaluations")
    public List<AnalyticsEvaluation> getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluations(List<AnalyticsEvaluation> evaluations) {
        this.evaluations = evaluations;
    }

    public AnalyticsConversation surveys(List<AnalyticsSurvey> surveys) {
        this.surveys = surveys;
        return this;
    }

    @ApiModelProperty(example="null", value="Surveys tied to this conversation")
    @JsonProperty(value="surveys")
    public List<AnalyticsSurvey> getSurveys() {
        return this.surveys;
    }

    public void setSurveys(List<AnalyticsSurvey> surveys) {
        this.surveys = surveys;
    }

    public AnalyticsConversation divisionIds(List<String> divisionIds) {
        this.divisionIds = divisionIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifiers of divisions associated with this conversation")
    @JsonProperty(value="divisionIds")
    public List<String> getDivisionIds() {
        return this.divisionIds;
    }

    public void setDivisionIds(List<String> divisionIds) {
        this.divisionIds = divisionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsConversation analyticsConversation = (AnalyticsConversation)o;
        return Objects.equals(this.conversationId, analyticsConversation.conversationId) && Objects.equals(this.conversationStart, analyticsConversation.conversationStart) && Objects.equals(this.conversationEnd, analyticsConversation.conversationEnd) && Objects.equals(this.mediaStatsMinConversationMos, analyticsConversation.mediaStatsMinConversationMos) && Objects.equals(this.mediaStatsMinConversationRFactor, analyticsConversation.mediaStatsMinConversationRFactor) && Objects.equals((Object)this.originatingDirection, (Object)analyticsConversation.originatingDirection) && Objects.equals(this.participants, analyticsConversation.participants) && Objects.equals(this.evaluations, analyticsConversation.evaluations) && Objects.equals(this.surveys, analyticsConversation.surveys) && Objects.equals(this.divisionIds, analyticsConversation.divisionIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversationId, this.conversationStart, this.conversationEnd, this.mediaStatsMinConversationMos, this.mediaStatsMinConversationRFactor, this.originatingDirection, this.participants, this.evaluations, this.surveys, this.divisionIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsConversation {\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    conversationStart: ").append(this.toIndentedString(this.conversationStart)).append("\n");
        sb.append("    conversationEnd: ").append(this.toIndentedString(this.conversationEnd)).append("\n");
        sb.append("    mediaStatsMinConversationMos: ").append(this.toIndentedString(this.mediaStatsMinConversationMos)).append("\n");
        sb.append("    mediaStatsMinConversationRFactor: ").append(this.toIndentedString(this.mediaStatsMinConversationRFactor)).append("\n");
        sb.append("    originatingDirection: ").append(this.toIndentedString((Object)this.originatingDirection)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    evaluations: ").append(this.toIndentedString(this.evaluations)).append("\n");
        sb.append("    surveys: ").append(this.toIndentedString(this.surveys)).append("\n");
        sb.append("    divisionIds: ").append(this.toIndentedString(this.divisionIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OriginatingDirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private OriginatingDirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginatingDirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginatingDirectionEnum value : OriginatingDirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginatingDirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

