/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RescheduleRequest
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private List<String> agentIds = new ArrayList<String>();
    private List<String> activityCodeIds = new ArrayList<String>();
    private Boolean doNotChangeWeeklyPaidTime = null;
    private Boolean doNotChangeDailyPaidTime = null;
    private Boolean doNotChangeShiftStartTimes = null;
    private Boolean doNotChangeManuallyEditedShifts = null;

    public RescheduleRequest startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date of the range to reschedule in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public RescheduleRequest endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The end date of the range to reschedule in ISO-8601 format")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public RescheduleRequest agentIds(List<String> agentIds) {
        this.agentIds = agentIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of the agents to reschedule.  Null or empty means all agents on the schedule")
    @JsonProperty(value="agentIds")
    public List<String> getAgentIds() {
        return this.agentIds;
    }

    public void setAgentIds(List<String> agentIds) {
        this.agentIds = agentIds;
    }

    public RescheduleRequest activityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of the activity codes to reschedule. Null or empty means all activity codes will be considered")
    @JsonProperty(value="activityCodeIds")
    public List<String> getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public RescheduleRequest doNotChangeWeeklyPaidTime(Boolean doNotChangeWeeklyPaidTime) {
        this.doNotChangeWeeklyPaidTime = doNotChangeWeeklyPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether to prevent changes to weekly paid time")
    @JsonProperty(value="doNotChangeWeeklyPaidTime")
    public Boolean getDoNotChangeWeeklyPaidTime() {
        return this.doNotChangeWeeklyPaidTime;
    }

    public void setDoNotChangeWeeklyPaidTime(Boolean doNotChangeWeeklyPaidTime) {
        this.doNotChangeWeeklyPaidTime = doNotChangeWeeklyPaidTime;
    }

    public RescheduleRequest doNotChangeDailyPaidTime(Boolean doNotChangeDailyPaidTime) {
        this.doNotChangeDailyPaidTime = doNotChangeDailyPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether to prevent changes to daily paid time")
    @JsonProperty(value="doNotChangeDailyPaidTime")
    public Boolean getDoNotChangeDailyPaidTime() {
        return this.doNotChangeDailyPaidTime;
    }

    public void setDoNotChangeDailyPaidTime(Boolean doNotChangeDailyPaidTime) {
        this.doNotChangeDailyPaidTime = doNotChangeDailyPaidTime;
    }

    public RescheduleRequest doNotChangeShiftStartTimes(Boolean doNotChangeShiftStartTimes) {
        this.doNotChangeShiftStartTimes = doNotChangeShiftStartTimes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether to prevent changes to shift start times")
    @JsonProperty(value="doNotChangeShiftStartTimes")
    public Boolean getDoNotChangeShiftStartTimes() {
        return this.doNotChangeShiftStartTimes;
    }

    public void setDoNotChangeShiftStartTimes(Boolean doNotChangeShiftStartTimes) {
        this.doNotChangeShiftStartTimes = doNotChangeShiftStartTimes;
    }

    public RescheduleRequest doNotChangeManuallyEditedShifts(Boolean doNotChangeManuallyEditedShifts) {
        this.doNotChangeManuallyEditedShifts = doNotChangeManuallyEditedShifts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether to prevent changes to manually edited shifts")
    @JsonProperty(value="doNotChangeManuallyEditedShifts")
    public Boolean getDoNotChangeManuallyEditedShifts() {
        return this.doNotChangeManuallyEditedShifts;
    }

    public void setDoNotChangeManuallyEditedShifts(Boolean doNotChangeManuallyEditedShifts) {
        this.doNotChangeManuallyEditedShifts = doNotChangeManuallyEditedShifts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RescheduleRequest rescheduleRequest = (RescheduleRequest)o;
        return Objects.equals(this.startDate, rescheduleRequest.startDate) && Objects.equals(this.endDate, rescheduleRequest.endDate) && Objects.equals(this.agentIds, rescheduleRequest.agentIds) && Objects.equals(this.activityCodeIds, rescheduleRequest.activityCodeIds) && Objects.equals(this.doNotChangeWeeklyPaidTime, rescheduleRequest.doNotChangeWeeklyPaidTime) && Objects.equals(this.doNotChangeDailyPaidTime, rescheduleRequest.doNotChangeDailyPaidTime) && Objects.equals(this.doNotChangeShiftStartTimes, rescheduleRequest.doNotChangeShiftStartTimes) && Objects.equals(this.doNotChangeManuallyEditedShifts, rescheduleRequest.doNotChangeManuallyEditedShifts);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.agentIds, this.activityCodeIds, this.doNotChangeWeeklyPaidTime, this.doNotChangeDailyPaidTime, this.doNotChangeShiftStartTimes, this.doNotChangeManuallyEditedShifts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RescheduleRequest {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    agentIds: ").append(this.toIndentedString(this.agentIds)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    doNotChangeWeeklyPaidTime: ").append(this.toIndentedString(this.doNotChangeWeeklyPaidTime)).append("\n");
        sb.append("    doNotChangeDailyPaidTime: ").append(this.toIndentedString(this.doNotChangeDailyPaidTime)).append("\n");
        sb.append("    doNotChangeShiftStartTimes: ").append(this.toIndentedString(this.doNotChangeShiftStartTimes)).append("\n");
        sb.append("    doNotChangeManuallyEditedShifts: ").append(this.toIndentedString(this.doNotChangeManuallyEditedShifts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

