/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SubjectDivisions;
import java.util.HashMap;
import java.util.Map;

public class PostAuthorizationRoleRequest {
    private String roleId;
    private SubjectDivisions body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public PostAuthorizationRoleRequest withRoleId(String roleId) {
        this.setRoleId(roleId);
        return this;
    }

    public SubjectDivisions getBody() {
        return this.body;
    }

    public void setBody(SubjectDivisions body) {
        this.body = body;
    }

    public PostAuthorizationRoleRequest withBody(SubjectDivisions body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostAuthorizationRoleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SubjectDivisions> withHttpInfo() {
        if (this.roleId == null) {
            throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PostAuthorizationRoleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAuthorizationRoleRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/authorization/roles/{roleId}").withPathParameter("roleId", this.roleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roleId, SubjectDivisions body) {
        return new Builder().withRequiredParams(roleId, body);
    }

    public static class Builder {
        private final PostAuthorizationRoleRequest request = new PostAuthorizationRoleRequest();

        private Builder() {
        }

        public Builder withRoleId(String roleId) {
            this.request.setRoleId(roleId);
            return this;
        }

        public Builder withBody(SubjectDivisions body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roleId, SubjectDivisions body) {
            this.request.setRoleId(roleId);
            this.request.setBody(body);
            return this;
        }

        public PostAuthorizationRoleRequest build() {
            if (this.request.roleId == null) {
                throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PostAuthorizationRoleRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAuthorizationRoleRequest.");
            }
            return this.request;
        }
    }
}

