/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CampaignSchedule;
import java.util.HashMap;
import java.util.Map;

public class PutOutboundSchedulesCampaignRequest {
    private String campaignId;
    private CampaignSchedule body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public PutOutboundSchedulesCampaignRequest withCampaignId(String campaignId) {
        this.setCampaignId(campaignId);
        return this;
    }

    public CampaignSchedule getBody() {
        return this.body;
    }

    public void setBody(CampaignSchedule body) {
        this.body = body;
    }

    public PutOutboundSchedulesCampaignRequest withBody(CampaignSchedule body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOutboundSchedulesCampaignRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CampaignSchedule> withHttpInfo() {
        if (this.campaignId == null) {
            throw new IllegalStateException("Missing the required parameter 'campaignId' when building request for PutOutboundSchedulesCampaignRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOutboundSchedulesCampaignRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/outbound/schedules/campaigns/{campaignId}").withPathParameter("campaignId", this.campaignId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String campaignId, CampaignSchedule body) {
        return new Builder().withRequiredParams(campaignId, body);
    }

    public static class Builder {
        private final PutOutboundSchedulesCampaignRequest request = new PutOutboundSchedulesCampaignRequest();

        private Builder() {
        }

        public Builder withCampaignId(String campaignId) {
            this.request.setCampaignId(campaignId);
            return this;
        }

        public Builder withBody(CampaignSchedule body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String campaignId, CampaignSchedule body) {
            this.request.setCampaignId(campaignId);
            this.request.setBody(body);
            return this;
        }

        public PutOutboundSchedulesCampaignRequest build() {
            if (this.request.campaignId == null) {
                throw new IllegalStateException("Missing the required parameter 'campaignId' when building request for PutOutboundSchedulesCampaignRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOutboundSchedulesCampaignRequest.");
            }
            return this.request;
        }
    }
}

