/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UserRoutingLanguage;
import java.util.HashMap;
import java.util.Map;

public class PatchUserRoutinglanguageRequest {
    private String userId;
    private String languageId;
    private UserRoutingLanguage body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchUserRoutinglanguageRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public PatchUserRoutinglanguageRequest withLanguageId(String languageId) {
        this.setLanguageId(languageId);
        return this;
    }

    public UserRoutingLanguage getBody() {
        return this.body;
    }

    public void setBody(UserRoutingLanguage body) {
        this.body = body;
    }

    public PatchUserRoutinglanguageRequest withBody(UserRoutingLanguage body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchUserRoutinglanguageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UserRoutingLanguage> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserRoutinglanguageRequest.");
        }
        if (this.languageId == null) {
            throw new IllegalStateException("Missing the required parameter 'languageId' when building request for PatchUserRoutinglanguageRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserRoutinglanguageRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/users/{userId}/routinglanguages/{languageId}").withPathParameter("userId", this.userId).withPathParameter("languageId", this.languageId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String languageId, UserRoutingLanguage body) {
        return new Builder().withRequiredParams(userId, languageId, body);
    }

    public static class Builder {
        private final PatchUserRoutinglanguageRequest request = new PatchUserRoutinglanguageRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withLanguageId(String languageId) {
            this.request.setLanguageId(languageId);
            return this;
        }

        public Builder withBody(UserRoutingLanguage body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, String languageId, UserRoutingLanguage body) {
            this.request.setUserId(userId);
            this.request.setLanguageId(languageId);
            this.request.setBody(body);
            return this;
        }

        public PatchUserRoutinglanguageRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserRoutinglanguageRequest.");
            }
            if (this.request.languageId == null) {
                throw new IllegalStateException("Missing the required parameter 'languageId' when building request for PatchUserRoutinglanguageRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserRoutinglanguageRequest.");
            }
            return this.request;
        }
    }
}

