/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HeartBeatRule
implements Serializable {
    private String id = null;
    private String name = null;
    private String senderId = null;
    private Integer heartBeatTimeoutInMinutes = null;
    private Boolean enabled = null;
    private Boolean inAlarm = null;
    private List<User> notificationUsers = new ArrayList<User>();
    private List<AlertTypesEnum> alertTypes = new ArrayList<AlertTypesEnum>();
    private RuleTypeEnum ruleType = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public HeartBeatRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the rule")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HeartBeatRule senderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value that identifies the sender of the heartbeat.")
    @JsonProperty(value="senderId")
    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public HeartBeatRule heartBeatTimeoutInMinutes(Integer heartBeatTimeoutInMinutes) {
        this.heartBeatTimeoutInMinutes = heartBeatTimeoutInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of minutes to wait before alerting missing heartbeats.")
    @JsonProperty(value="heartBeatTimeoutInMinutes")
    public Integer getHeartBeatTimeoutInMinutes() {
        return this.heartBeatTimeoutInMinutes;
    }

    public void setHeartBeatTimeoutInMinutes(Integer heartBeatTimeoutInMinutes) {
        this.heartBeatTimeoutInMinutes = heartBeatTimeoutInMinutes;
    }

    public HeartBeatRule enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates if the rule is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(example="null", value="Indicates if the rule is in alarm state.")
    @JsonProperty(value="inAlarm")
    public Boolean getInAlarm() {
        return this.inAlarm;
    }

    public HeartBeatRule notificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ids of users who will be notified of alarm state change.")
    @JsonProperty(value="notificationUsers")
    public List<User> getNotificationUsers() {
        return this.notificationUsers;
    }

    public void setNotificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
    }

    public HeartBeatRule alertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A collection of notification methods.")
    @JsonProperty(value="alertTypes")
    public List<AlertTypesEnum> getAlertTypes() {
        return this.alertTypes;
    }

    public void setAlertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
    }

    public HeartBeatRule ruleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of system the will be generating the heartbeat.")
    @JsonProperty(value="ruleType")
    public RuleTypeEnum getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeartBeatRule heartBeatRule = (HeartBeatRule)o;
        return Objects.equals(this.id, heartBeatRule.id) && Objects.equals(this.name, heartBeatRule.name) && Objects.equals(this.senderId, heartBeatRule.senderId) && Objects.equals(this.heartBeatTimeoutInMinutes, heartBeatRule.heartBeatTimeoutInMinutes) && Objects.equals(this.enabled, heartBeatRule.enabled) && Objects.equals(this.inAlarm, heartBeatRule.inAlarm) && Objects.equals(this.notificationUsers, heartBeatRule.notificationUsers) && Objects.equals(this.alertTypes, heartBeatRule.alertTypes) && Objects.equals((Object)this.ruleType, (Object)heartBeatRule.ruleType) && Objects.equals(this.selfUri, heartBeatRule.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.senderId, this.heartBeatTimeoutInMinutes, this.enabled, this.inAlarm, this.notificationUsers, this.alertTypes, this.ruleType, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeartBeatRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    senderId: ").append(this.toIndentedString(this.senderId)).append("\n");
        sb.append("    heartBeatTimeoutInMinutes: ").append(this.toIndentedString(this.heartBeatTimeoutInMinutes)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    inAlarm: ").append(this.toIndentedString(this.inAlarm)).append("\n");
        sb.append("    notificationUsers: ").append(this.toIndentedString(this.notificationUsers)).append("\n");
        sb.append("    alertTypes: ").append(this.toIndentedString(this.alertTypes)).append("\n");
        sb.append("    ruleType: ").append(this.toIndentedString((Object)this.ruleType)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RuleTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EDGE("EDGE");

        private String value;

        private RuleTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RuleTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RuleTypeEnum value : RuleTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RuleTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum AlertTypesEnum {
        SMS("SMS"),
        DEVICE("DEVICE"),
        EMAIL("EMAIL");

        private String value;

        private AlertTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlertTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlertTypesEnum value : AlertTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlertTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

