/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AnalyticsQueryAggregation;
import com.mypurecloud.sdk.v2.model.AnalyticsQueryFilter;
import com.mypurecloud.sdk.v2.model.PagingSpec;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConversationQuery
implements Serializable {
    private String interval = null;
    private List<AnalyticsQueryFilter> conversationFilters = new ArrayList<AnalyticsQueryFilter>();
    private List<AnalyticsQueryFilter> evaluationFilters = new ArrayList<AnalyticsQueryFilter>();
    private List<AnalyticsQueryFilter> surveyFilters = new ArrayList<AnalyticsQueryFilter>();
    private List<AnalyticsQueryFilter> segmentFilters = new ArrayList<AnalyticsQueryFilter>();
    private List<AnalyticsQueryAggregation> aggregations = new ArrayList<AnalyticsQueryAggregation>();
    private PagingSpec paging = null;
    private OrderEnum order = null;
    private OrderByEnum orderBy = null;

    public ConversationQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the date and time range of data being queried. Results will include conversations that started, ended, or had any activity during the interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public ConversationQuery conversationFilters(List<AnalyticsQueryFilter> conversationFilters) {
        this.conversationFilters = conversationFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target conversation-level data")
    @JsonProperty(value="conversationFilters")
    public List<AnalyticsQueryFilter> getConversationFilters() {
        return this.conversationFilters;
    }

    public void setConversationFilters(List<AnalyticsQueryFilter> conversationFilters) {
        this.conversationFilters = conversationFilters;
    }

    public ConversationQuery evaluationFilters(List<AnalyticsQueryFilter> evaluationFilters) {
        this.evaluationFilters = evaluationFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target quality management evaluation-level data")
    @JsonProperty(value="evaluationFilters")
    public List<AnalyticsQueryFilter> getEvaluationFilters() {
        return this.evaluationFilters;
    }

    public void setEvaluationFilters(List<AnalyticsQueryFilter> evaluationFilters) {
        this.evaluationFilters = evaluationFilters;
    }

    public ConversationQuery surveyFilters(List<AnalyticsQueryFilter> surveyFilters) {
        this.surveyFilters = surveyFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target quality management survey-level data")
    @JsonProperty(value="surveyFilters")
    public List<AnalyticsQueryFilter> getSurveyFilters() {
        return this.surveyFilters;
    }

    public void setSurveyFilters(List<AnalyticsQueryFilter> surveyFilters) {
        this.surveyFilters = surveyFilters;
    }

    public ConversationQuery segmentFilters(List<AnalyticsQueryFilter> segmentFilters) {
        this.segmentFilters = segmentFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target individual segments within a conversation")
    @JsonProperty(value="segmentFilters")
    public List<AnalyticsQueryFilter> getSegmentFilters() {
        return this.segmentFilters;
    }

    public void setSegmentFilters(List<AnalyticsQueryFilter> segmentFilters) {
        this.segmentFilters = segmentFilters;
    }

    public ConversationQuery aggregations(List<AnalyticsQueryAggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @ApiModelProperty(example="null", value="Include faceted search and aggregate roll-ups describing your search results. This does not function as a filter, but rather, summary data about the data matching your filters")
    @JsonProperty(value="aggregations")
    public List<AnalyticsQueryAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<AnalyticsQueryAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public ConversationQuery paging(PagingSpec paging) {
        this.paging = paging;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size and number to control iterating through large result sets. Default page size is 25")
    @JsonProperty(value="paging")
    public PagingSpec getPaging() {
        return this.paging;
    }

    public void setPaging(PagingSpec paging) {
        this.paging = paging;
    }

    public ConversationQuery order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort the result set in ascending/descending order. Default is ascending")
    @JsonProperty(value="order")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public ConversationQuery orderBy(OrderByEnum orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify which data element within the result set to use for sorting. The options  to use as a basis for sorting the results: conversationStart, segmentStart, and segmentEnd. If not specified, the default is conversationStart")
    @JsonProperty(value="orderBy")
    public OrderByEnum getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderByEnum orderBy) {
        this.orderBy = orderBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationQuery conversationQuery = (ConversationQuery)o;
        return Objects.equals(this.interval, conversationQuery.interval) && Objects.equals(this.conversationFilters, conversationQuery.conversationFilters) && Objects.equals(this.evaluationFilters, conversationQuery.evaluationFilters) && Objects.equals(this.surveyFilters, conversationQuery.surveyFilters) && Objects.equals(this.segmentFilters, conversationQuery.segmentFilters) && Objects.equals(this.aggregations, conversationQuery.aggregations) && Objects.equals(this.paging, conversationQuery.paging) && Objects.equals((Object)this.order, (Object)conversationQuery.order) && Objects.equals((Object)this.orderBy, (Object)conversationQuery.orderBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.conversationFilters, this.evaluationFilters, this.surveyFilters, this.segmentFilters, this.aggregations, this.paging, this.order, this.orderBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    conversationFilters: ").append(this.toIndentedString(this.conversationFilters)).append("\n");
        sb.append("    evaluationFilters: ").append(this.toIndentedString(this.evaluationFilters)).append("\n");
        sb.append("    surveyFilters: ").append(this.toIndentedString(this.surveyFilters)).append("\n");
        sb.append("    segmentFilters: ").append(this.toIndentedString(this.segmentFilters)).append("\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("    orderBy: ").append(this.toIndentedString((Object)this.orderBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONVERSATIONSTART("conversationStart"),
        CONVERSATIONEND("conversationEnd"),
        SEGMENTSTART("segmentStart"),
        SEGMENTEND("segmentEnd");

        private String value;

        private OrderByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderByEnum value : OrderByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum OrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderEnum value : OrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

