/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.RoutingData;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateCallbackOnConversationCommand
implements Serializable {
    private String scriptId = null;
    private String queueId = null;
    private RoutingData routingData = null;
    private String callbackUserName = null;
    private List<String> callbackNumbers = new ArrayList<String>();
    private Date callbackScheduledTime = null;
    private String countryCode = null;
    private Map<String, String> data = null;

    public CreateCallbackOnConversationCommand scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The identifier of the script to be used for the callback")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public CreateCallbackOnConversationCommand queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The identifier of the queue to be used for the callback. Either queueId or routingData is required.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public CreateCallbackOnConversationCommand routingData(RoutingData routingData) {
        this.routingData = routingData;
        return this;
    }

    @ApiModelProperty(example="null", value="The routing data to be used for the callback. Either queueId or routingData is required.")
    @JsonProperty(value="routingData")
    public RoutingData getRoutingData() {
        return this.routingData;
    }

    public void setRoutingData(RoutingData routingData) {
        this.routingData = routingData;
    }

    public CreateCallbackOnConversationCommand callbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the party to be called back.")
    @JsonProperty(value="callbackUserName")
    public String getCallbackUserName() {
        return this.callbackUserName;
    }

    public void setCallbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
    }

    public CreateCallbackOnConversationCommand callbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of phone numbers for the callback.")
    @JsonProperty(value="callbackNumbers")
    public List<String> getCallbackNumbers() {
        return this.callbackNumbers;
    }

    public void setCallbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
    }

    public CreateCallbackOnConversationCommand callbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
        return this;
    }

    @ApiModelProperty(example="2015-01-02T16:59:59.000Z", value="The scheduled date-time for the callback as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="callbackScheduledTime")
    public Date getCallbackScheduledTime() {
        return this.callbackScheduledTime;
    }

    public void setCallbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
    }

    public CreateCallbackOnConversationCommand countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The country code to be associated with the callback numbers.")
    @JsonProperty(value="countryCode")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CreateCallbackOnConversationCommand data(Map<String, String> data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(example="null", value="A map of key-value pairs containing additional data that can be associated to the callback. These values will appear in the attributes property on the conversation participant. Example: { \"notes\": \"ready to close the deal!\", \"customerPreferredName\": \"Doc\" }")
    @JsonProperty(value="data")
    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCallbackOnConversationCommand createCallbackOnConversationCommand = (CreateCallbackOnConversationCommand)o;
        return Objects.equals(this.scriptId, createCallbackOnConversationCommand.scriptId) && Objects.equals(this.queueId, createCallbackOnConversationCommand.queueId) && Objects.equals(this.routingData, createCallbackOnConversationCommand.routingData) && Objects.equals(this.callbackUserName, createCallbackOnConversationCommand.callbackUserName) && Objects.equals(this.callbackNumbers, createCallbackOnConversationCommand.callbackNumbers) && Objects.equals(this.callbackScheduledTime, createCallbackOnConversationCommand.callbackScheduledTime) && Objects.equals(this.countryCode, createCallbackOnConversationCommand.countryCode) && Objects.equals(this.data, createCallbackOnConversationCommand.data);
    }

    public int hashCode() {
        return Objects.hash(this.scriptId, this.queueId, this.routingData, this.callbackUserName, this.callbackNumbers, this.callbackScheduledTime, this.countryCode, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCallbackOnConversationCommand {\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    routingData: ").append(this.toIndentedString(this.routingData)).append("\n");
        sb.append("    callbackUserName: ").append(this.toIndentedString(this.callbackUserName)).append("\n");
        sb.append("    callbackNumbers: ").append(this.toIndentedString(this.callbackNumbers)).append("\n");
        sb.append("    callbackScheduledTime: ").append(this.toIndentedString(this.callbackScheduledTime)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

