/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetDateRequest;
import com.mypurecloud.sdk.v2.api.request.GetTimezonesRequest;
import com.mypurecloud.sdk.v2.api.request.PostCertificateDetailsRequest;
import com.mypurecloud.sdk.v2.model.Certificate;
import com.mypurecloud.sdk.v2.model.ParsedCertificate;
import com.mypurecloud.sdk.v2.model.ServerDate;
import com.mypurecloud.sdk.v2.model.TimeZoneEntityListing;
import java.io.IOException;

public class UtilitiesApi {
    private final ApiClient pcapiClient;

    public UtilitiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UtilitiesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public ServerDate getDate() throws IOException, ApiException {
        return this.getDate(this.createGetDateRequest());
    }

    public ApiResponse<ServerDate> getDateWithHttpInfo() throws IOException {
        return this.getDate(this.createGetDateRequest().withHttpInfo());
    }

    private GetDateRequest createGetDateRequest() {
        return GetDateRequest.builder().build();
    }

    public ServerDate getDate(GetDateRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ServerDate> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ServerDate>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ServerDate> getDate(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ServerDate>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TimeZoneEntityListing getTimezones(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getTimezones(this.createGetTimezonesRequest(pageSize, pageNumber));
    }

    public ApiResponse<TimeZoneEntityListing> getTimezonesWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getTimezones(this.createGetTimezonesRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetTimezonesRequest createGetTimezonesRequest(Integer pageSize, Integer pageNumber) {
        return GetTimezonesRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public TimeZoneEntityListing getTimezones(GetTimezonesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TimeZoneEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TimeZoneEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TimeZoneEntityListing> getTimezones(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TimeZoneEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ParsedCertificate postCertificateDetails(Certificate body) throws IOException, ApiException {
        return this.postCertificateDetails(this.createPostCertificateDetailsRequest(body));
    }

    public ApiResponse<ParsedCertificate> postCertificateDetailsWithHttpInfo(Certificate body) throws IOException {
        return this.postCertificateDetails(this.createPostCertificateDetailsRequest(body).withHttpInfo());
    }

    private PostCertificateDetailsRequest createPostCertificateDetailsRequest(Certificate body) {
        return PostCertificateDetailsRequest.builder().withBody(body).build();
    }

    public ParsedCertificate postCertificateDetails(PostCertificateDetailsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ParsedCertificate> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ParsedCertificate>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ParsedCertificate> postCertificateDetails(ApiRequest<Certificate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ParsedCertificate>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

