/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OAuthClient
implements Serializable {
    private String id = null;
    private String name = null;
    private Long accessTokenValiditySeconds = null;
    private String description = null;
    private List<String> registeredRedirectUri = new ArrayList<String>();
    private String secret = null;
    private List<String> roleIds = new ArrayList<String>();
    private AuthorizedGrantTypeEnum authorizedGrantType = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OAuthClient name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the OAuth client.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OAuthClient accessTokenValiditySeconds(Long accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds, between 5mins and 48hrs, until tokens created with this client expire. If this field is omitted, a default of 24 hours will be applied.")
    @JsonProperty(value="accessTokenValiditySeconds")
    public Long getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(Long accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public OAuthClient description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OAuthClient registeredRedirectUri(List<String> registeredRedirectUri) {
        this.registeredRedirectUri = registeredRedirectUri;
        return this;
    }

    @ApiModelProperty(example="null", value="List of allowed callbacks for this client. For example: https://myap.example.com/auth/callback")
    @JsonProperty(value="registeredRedirectUri")
    public List<String> getRegisteredRedirectUri() {
        return this.registeredRedirectUri;
    }

    public void setRegisteredRedirectUri(List<String> registeredRedirectUri) {
        this.registeredRedirectUri = registeredRedirectUri;
    }

    public OAuthClient secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(example="null", value="System created secret assigned to this client. Secrets are required for code authorization and client credential grants.")
    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public OAuthClient roleIds(List<String> roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Roles assigned to this client. Roles only apply to clients using the client_credential grant")
    @JsonProperty(value="roleIds")
    public List<String> getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(List<String> roleIds) {
        this.roleIds = roleIds;
    }

    public OAuthClient authorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client. ")
    @JsonProperty(value="authorizedGrantType")
    public AuthorizedGrantTypeEnum getAuthorizedGrantType() {
        return this.authorizedGrantType;
    }

    public void setAuthorizedGrantType(AuthorizedGrantTypeEnum authorizedGrantType) {
        this.authorizedGrantType = authorizedGrantType;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClient oAuthClient = (OAuthClient)o;
        return Objects.equals(this.id, oAuthClient.id) && Objects.equals(this.name, oAuthClient.name) && Objects.equals(this.accessTokenValiditySeconds, oAuthClient.accessTokenValiditySeconds) && Objects.equals(this.description, oAuthClient.description) && Objects.equals(this.registeredRedirectUri, oAuthClient.registeredRedirectUri) && Objects.equals(this.secret, oAuthClient.secret) && Objects.equals(this.roleIds, oAuthClient.roleIds) && Objects.equals((Object)this.authorizedGrantType, (Object)oAuthClient.authorizedGrantType) && Objects.equals(this.selfUri, oAuthClient.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.accessTokenValiditySeconds, this.description, this.registeredRedirectUri, this.secret, this.roleIds, this.authorizedGrantType, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthClient {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accessTokenValiditySeconds: ").append(this.toIndentedString(this.accessTokenValiditySeconds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    registeredRedirectUri: ").append(this.toIndentedString(this.registeredRedirectUri)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    roleIds: ").append(this.toIndentedString(this.roleIds)).append("\n");
        sb.append("    authorizedGrantType: ").append(this.toIndentedString((Object)this.authorizedGrantType)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthorizedGrantTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CODE("CODE"),
        TOKEN("TOKEN"),
        SAML2BEARER("SAML2BEARER"),
        PASSWORD("PASSWORD"),
        CLIENT_CREDENTIALS("CLIENT_CREDENTIALS");

        private String value;

        private AuthorizedGrantTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthorizedGrantTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AuthorizedGrantTypeEnum value : AuthorizedGrantTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AuthorizedGrantTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

