/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DisconnectReason;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.FaxStatus;
import com.mypurecloud.sdk.v2.model.Segment;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CallBasic
implements Serializable {
    private StateEnum state = null;
    private String id = null;
    private DirectionEnum direction = null;
    private Boolean recording = null;
    private RecordingStateEnum recordingState = null;
    private Boolean muted = null;
    private Boolean confined = null;
    private Boolean held = null;
    private String recordingId = null;
    private List<Segment> segments = new ArrayList<Segment>();
    private ErrorBody errorInfo = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startHoldTime = null;
    private String documentId = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private List<DisconnectReason> disconnectReasons = new ArrayList<DisconnectReason>();
    private FaxStatus faxStatus = null;
    private String provider = null;
    private String scriptId = null;

    public CallBasic state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CallBasic id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CallBasic direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the call")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CallBasic recording(Boolean recording) {
        this.recording = recording;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is being recorded.")
    @JsonProperty(value="recording")
    public Boolean getRecording() {
        return this.recording;
    }

    public void setRecording(Boolean recording) {
        this.recording = recording;
    }

    public CallBasic recordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
        return this;
    }

    @ApiModelProperty(example="null", value="State of recording on this call.")
    @JsonProperty(value="recordingState")
    public RecordingStateEnum getRecordingState() {
        return this.recordingState;
    }

    public void setRecordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
    }

    public CallBasic muted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is muted so that remote participants can't hear any audio from this end.")
    @JsonProperty(value="muted")
    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public CallBasic confined(Boolean confined) {
        this.confined = confined;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears hold music.")
    @JsonProperty(value="confined")
    public Boolean getConfined() {
        return this.confined;
    }

    public void setConfined(Boolean confined) {
        this.confined = confined;
    }

    public CallBasic held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears silence.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public CallBasic recordingId(String recordingId) {
        this.recordingId = recordingId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the recording associated with this call.")
    @JsonProperty(value="recordingId")
    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public CallBasic segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's call, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public CallBasic errorInfo(ErrorBody errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorInfo")
    public ErrorBody getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorBody errorInfo) {
        this.errorInfo = errorInfo;
    }

    public CallBasic disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public CallBasic startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the call was placed on hold in the cloud clock if the call is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public CallBasic documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="null", value="If call is an outbound fax of a document from content management, then this is the id in content management.")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public CallBasic connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public CallBasic disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public CallBasic disconnectReasons(List<DisconnectReason> disconnectReasons) {
        this.disconnectReasons = disconnectReasons;
        return this;
    }

    @ApiModelProperty(example="null", value="List of reasons that this call was disconnected. This will be set once the call disconnects.")
    @JsonProperty(value="disconnectReasons")
    public List<DisconnectReason> getDisconnectReasons() {
        return this.disconnectReasons;
    }

    public void setDisconnectReasons(List<DisconnectReason> disconnectReasons) {
        this.disconnectReasons = disconnectReasons;
    }

    public CallBasic faxStatus(FaxStatus faxStatus) {
        this.faxStatus = faxStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Extra information on fax transmission.")
    @JsonProperty(value="faxStatus")
    public FaxStatus getFaxStatus() {
        return this.faxStatus;
    }

    public void setFaxStatus(FaxStatus faxStatus) {
        this.faxStatus = faxStatus;
    }

    public CallBasic provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the call.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public CallBasic scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID of the script to use.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallBasic callBasic = (CallBasic)o;
        return Objects.equals((Object)this.state, (Object)callBasic.state) && Objects.equals(this.id, callBasic.id) && Objects.equals((Object)this.direction, (Object)callBasic.direction) && Objects.equals(this.recording, callBasic.recording) && Objects.equals((Object)this.recordingState, (Object)callBasic.recordingState) && Objects.equals(this.muted, callBasic.muted) && Objects.equals(this.confined, callBasic.confined) && Objects.equals(this.held, callBasic.held) && Objects.equals(this.recordingId, callBasic.recordingId) && Objects.equals(this.segments, callBasic.segments) && Objects.equals(this.errorInfo, callBasic.errorInfo) && Objects.equals((Object)this.disconnectType, (Object)callBasic.disconnectType) && Objects.equals(this.startHoldTime, callBasic.startHoldTime) && Objects.equals(this.documentId, callBasic.documentId) && Objects.equals(this.connectedTime, callBasic.connectedTime) && Objects.equals(this.disconnectedTime, callBasic.disconnectedTime) && Objects.equals(this.disconnectReasons, callBasic.disconnectReasons) && Objects.equals(this.faxStatus, callBasic.faxStatus) && Objects.equals(this.provider, callBasic.provider) && Objects.equals(this.scriptId, callBasic.scriptId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.id, this.direction, this.recording, this.recordingState, this.muted, this.confined, this.held, this.recordingId, this.segments, this.errorInfo, this.disconnectType, this.startHoldTime, this.documentId, this.connectedTime, this.disconnectedTime, this.disconnectReasons, this.faxStatus, this.provider, this.scriptId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallBasic {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    recording: ").append(this.toIndentedString(this.recording)).append("\n");
        sb.append("    recordingState: ").append(this.toIndentedString((Object)this.recordingState)).append("\n");
        sb.append("    muted: ").append(this.toIndentedString(this.muted)).append("\n");
        sb.append("    confined: ").append(this.toIndentedString(this.confined)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    recordingId: ").append(this.toIndentedString(this.recordingId)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    disconnectReasons: ").append(this.toIndentedString(this.disconnectReasons)).append("\n");
        sb.append("    faxStatus: ").append(this.toIndentedString(this.faxStatus)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum RecordingStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        ACTIVE("active"),
        PAUSED("paused");

        private String value;

        private RecordingStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingStateEnum value : RecordingStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

