/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteGroupMembersRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteGroupRequest;
import com.mypurecloud.sdk.v2.api.request.GetFieldconfigRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupMembersRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupMembersRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PutGroupRequest;
import com.mypurecloud.sdk.v2.model.Empty;
import com.mypurecloud.sdk.v2.model.FieldConfig;
import com.mypurecloud.sdk.v2.model.Group;
import com.mypurecloud.sdk.v2.model.GroupEntityListing;
import com.mypurecloud.sdk.v2.model.GroupMembersUpdate;
import com.mypurecloud.sdk.v2.model.GroupSearchRequest;
import com.mypurecloud.sdk.v2.model.GroupUpdate;
import com.mypurecloud.sdk.v2.model.GroupsSearchResponse;
import com.mypurecloud.sdk.v2.model.UserEntityListing;
import java.io.IOException;
import java.util.List;

public class GroupsApi {
    private final ApiClient pcapiClient;

    public GroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteGroup(String groupId) throws IOException, ApiException {
        this.deleteGroup(this.createDeleteGroupRequest(groupId));
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(String groupId) throws IOException {
        return this.deleteGroup(this.createDeleteGroupRequest(groupId).withHttpInfo());
    }

    private DeleteGroupRequest createDeleteGroupRequest(String groupId) {
        return DeleteGroupRequest.builder().withGroupId(groupId).build();
    }

    public void deleteGroup(DeleteGroupRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteGroup(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Empty deleteGroupMembers(String groupId, String ids) throws IOException, ApiException {
        return this.deleteGroupMembers(this.createDeleteGroupMembersRequest(groupId, ids));
    }

    public ApiResponse<Empty> deleteGroupMembersWithHttpInfo(String groupId, String ids) throws IOException {
        return this.deleteGroupMembers(this.createDeleteGroupMembersRequest(groupId, ids).withHttpInfo());
    }

    private DeleteGroupMembersRequest createDeleteGroupMembersRequest(String groupId, String ids) {
        return DeleteGroupMembersRequest.builder().withGroupId(groupId).withIds(ids).build();
    }

    public Empty deleteGroupMembers(DeleteGroupMembersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Empty> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Empty>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Empty> deleteGroupMembers(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Empty>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public FieldConfig getFieldconfig(String type) throws IOException, ApiException {
        return this.getFieldconfig(this.createGetFieldconfigRequest(type));
    }

    public ApiResponse<FieldConfig> getFieldconfigWithHttpInfo(String type) throws IOException {
        return this.getFieldconfig(this.createGetFieldconfigRequest(type).withHttpInfo());
    }

    private GetFieldconfigRequest createGetFieldconfigRequest(String type) {
        return GetFieldconfigRequest.builder().withType(type).build();
    }

    public FieldConfig getFieldconfig(GetFieldconfigRequest request) throws IOException, ApiException {
        try {
            ApiResponse<FieldConfig> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<FieldConfig>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<FieldConfig> getFieldconfig(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<FieldConfig>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Group getGroup(String groupId) throws IOException, ApiException {
        return this.getGroup(this.createGetGroupRequest(groupId));
    }

    public ApiResponse<Group> getGroupWithHttpInfo(String groupId) throws IOException {
        return this.getGroup(this.createGetGroupRequest(groupId).withHttpInfo());
    }

    private GetGroupRequest createGetGroupRequest(String groupId) {
        return GetGroupRequest.builder().withGroupId(groupId).build();
    }

    public Group getGroup(GetGroupRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Group> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Group>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Group> getGroup(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Group>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserEntityListing getGroupMembers(String groupId, Integer pageSize, Integer pageNumber, String sortOrder, List<String> expand) throws IOException, ApiException {
        return this.getGroupMembers(this.createGetGroupMembersRequest(groupId, pageSize, pageNumber, sortOrder, expand));
    }

    public ApiResponse<UserEntityListing> getGroupMembersWithHttpInfo(String groupId, Integer pageSize, Integer pageNumber, String sortOrder, List<String> expand) throws IOException {
        return this.getGroupMembers(this.createGetGroupMembersRequest(groupId, pageSize, pageNumber, sortOrder, expand).withHttpInfo());
    }

    private GetGroupMembersRequest createGetGroupMembersRequest(String groupId, Integer pageSize, Integer pageNumber, String sortOrder, List<String> expand) {
        return GetGroupMembersRequest.builder().withGroupId(groupId).withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).withExpand(expand).build();
    }

    public UserEntityListing getGroupMembers(GetGroupMembersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserEntityListing> getGroupMembers(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GroupEntityListing getGroups(Integer pageSize, Integer pageNumber, String sortOrder) throws IOException, ApiException {
        return this.getGroups(this.createGetGroupsRequest(pageSize, pageNumber, sortOrder));
    }

    public ApiResponse<GroupEntityListing> getGroupsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortOrder) throws IOException {
        return this.getGroups(this.createGetGroupsRequest(pageSize, pageNumber, sortOrder).withHttpInfo());
    }

    private GetGroupsRequest createGetGroupsRequest(Integer pageSize, Integer pageNumber, String sortOrder) {
        return GetGroupsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).build();
    }

    public GroupEntityListing getGroups(GetGroupsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GroupEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GroupEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GroupEntityListing> getGroups(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GroupEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GroupsSearchResponse getGroupsSearch(String q64, List<String> expand) throws IOException, ApiException {
        return this.getGroupsSearch(this.createGetGroupsSearchRequest(q64, expand));
    }

    public ApiResponse<GroupsSearchResponse> getGroupsSearchWithHttpInfo(String q64, List<String> expand) throws IOException {
        return this.getGroupsSearch(this.createGetGroupsSearchRequest(q64, expand).withHttpInfo());
    }

    private GetGroupsSearchRequest createGetGroupsSearchRequest(String q64, List<String> expand) {
        return GetGroupsSearchRequest.builder().withQ64(q64).withExpand(expand).build();
    }

    public GroupsSearchResponse getGroupsSearch(GetGroupsSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GroupsSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GroupsSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GroupsSearchResponse> getGroupsSearch(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GroupsSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Empty postGroupMembers(String groupId, GroupMembersUpdate body) throws IOException, ApiException {
        return this.postGroupMembers(this.createPostGroupMembersRequest(groupId, body));
    }

    public ApiResponse<Empty> postGroupMembersWithHttpInfo(String groupId, GroupMembersUpdate body) throws IOException {
        return this.postGroupMembers(this.createPostGroupMembersRequest(groupId, body).withHttpInfo());
    }

    private PostGroupMembersRequest createPostGroupMembersRequest(String groupId, GroupMembersUpdate body) {
        return PostGroupMembersRequest.builder().withGroupId(groupId).withBody(body).build();
    }

    public Empty postGroupMembers(PostGroupMembersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Empty> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Empty>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Empty> postGroupMembers(ApiRequest<GroupMembersUpdate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Empty>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Group postGroups(Group body) throws IOException, ApiException {
        return this.postGroups(this.createPostGroupsRequest(body));
    }

    public ApiResponse<Group> postGroupsWithHttpInfo(Group body) throws IOException {
        return this.postGroups(this.createPostGroupsRequest(body).withHttpInfo());
    }

    private PostGroupsRequest createPostGroupsRequest(Group body) {
        return PostGroupsRequest.builder().withBody(body).build();
    }

    public Group postGroups(PostGroupsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Group> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Group>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Group> postGroups(ApiRequest<Group> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Group>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GroupsSearchResponse postGroupsSearch(GroupSearchRequest body) throws IOException, ApiException {
        return this.postGroupsSearch(this.createPostGroupsSearchRequest(body));
    }

    public ApiResponse<GroupsSearchResponse> postGroupsSearchWithHttpInfo(GroupSearchRequest body) throws IOException {
        return this.postGroupsSearch(this.createPostGroupsSearchRequest(body).withHttpInfo());
    }

    private PostGroupsSearchRequest createPostGroupsSearchRequest(GroupSearchRequest body) {
        return PostGroupsSearchRequest.builder().withBody(body).build();
    }

    public GroupsSearchResponse postGroupsSearch(PostGroupsSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GroupsSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GroupsSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GroupsSearchResponse> postGroupsSearch(ApiRequest<GroupSearchRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GroupsSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Group putGroup(String groupId, GroupUpdate body) throws IOException, ApiException {
        return this.putGroup(this.createPutGroupRequest(groupId, body));
    }

    public ApiResponse<Group> putGroupWithHttpInfo(String groupId, GroupUpdate body) throws IOException {
        return this.putGroup(this.createPutGroupRequest(groupId, body).withHttpInfo());
    }

    private PutGroupRequest createPutGroupRequest(String groupId, GroupUpdate body) {
        return PutGroupRequest.builder().withGroupId(groupId).withBody(body).build();
    }

    public Group putGroup(PutGroupRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Group> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Group>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Group> putGroup(ApiRequest<GroupUpdate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Group>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

