/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UserRecording;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PutUserrecordingRequest {
    private String recordingId;
    private UserRecording body;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public PutUserrecordingRequest withRecordingId(String recordingId) {
        this.setRecordingId(recordingId);
        return this;
    }

    public UserRecording getBody() {
        return this.body;
    }

    public void setBody(UserRecording body) {
        this.body = body;
    }

    public PutUserrecordingRequest withBody(UserRecording body) {
        this.setBody(body);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public PutUserrecordingRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutUserrecordingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UserRecording> withHttpInfo() {
        if (this.recordingId == null) {
            throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for PutUserrecordingRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserrecordingRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/userrecordings/{recordingId}").withPathParameter("recordingId", this.recordingId).withQueryParameters("expand", "multi", this.expand).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String recordingId, UserRecording body) {
        return new Builder().withRequiredParams(recordingId, body);
    }

    public static class Builder {
        private final PutUserrecordingRequest request = new PutUserrecordingRequest();

        private Builder() {
        }

        public Builder withRecordingId(String recordingId) {
            this.request.setRecordingId(recordingId);
            return this;
        }

        public Builder withBody(UserRecording body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String recordingId, UserRecording body) {
            this.request.setRecordingId(recordingId);
            this.request.setBody(body);
            return this;
        }

        public PutUserrecordingRequest build() {
            if (this.request.recordingId == null) {
                throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for PutUserrecordingRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserrecordingRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        CONVERSATION("conversation");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

