/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetIntegrationRequest {
    private String integrationId;
    private Integer pageSize;
    private Integer pageNumber;
    private String sortBy;
    private List<String> expand;
    private String nextPage;
    private String previousPage;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public GetIntegrationRequest withIntegrationId(String integrationId) {
        this.setIntegrationId(integrationId);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetIntegrationRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetIntegrationRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public GetIntegrationRequest withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetIntegrationRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(String nextPage) {
        this.nextPage = nextPage;
    }

    public GetIntegrationRequest withNextPage(String nextPage) {
        this.setNextPage(nextPage);
        return this;
    }

    public String getPreviousPage() {
        return this.previousPage;
    }

    public void setPreviousPage(String previousPage) {
        this.previousPage = previousPage;
    }

    public GetIntegrationRequest withPreviousPage(String previousPage) {
        this.setPreviousPage(previousPage);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetIntegrationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.integrationId == null) {
            throw new IllegalStateException("Missing the required parameter 'integrationId' when building request for GetIntegrationRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/integrations/{integrationId}").withPathParameter("integrationId", this.integrationId).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("pageNumber", "", this.pageNumber).withQueryParameters("sortBy", "", this.sortBy).withQueryParameters("expand", "multi", this.expand).withQueryParameters("nextPage", "", this.nextPage).withQueryParameters("previousPage", "", this.previousPage).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String integrationId) {
        return new Builder().withRequiredParams(integrationId);
    }

    public static class Builder {
        private final GetIntegrationRequest request = new GetIntegrationRequest();

        private Builder() {
        }

        public Builder withIntegrationId(String integrationId) {
            this.request.setIntegrationId(integrationId);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public Builder withSortBy(String sortBy) {
            this.request.setSortBy(sortBy);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withNextPage(String nextPage) {
            this.request.setNextPage(nextPage);
            return this;
        }

        public Builder withPreviousPage(String previousPage) {
            this.request.setPreviousPage(previousPage);
            return this;
        }

        public Builder withRequiredParams(String integrationId) {
            this.request.setIntegrationId(integrationId);
            return this;
        }

        public GetIntegrationRequest build() {
            if (this.request.integrationId == null) {
                throw new IllegalStateException("Missing the required parameter 'integrationId' when building request for GetIntegrationRequest.");
            }
            return this.request;
        }
    }
}

