/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Credential;
import java.util.HashMap;
import java.util.Map;

public class PutIntegrationsCredentialRequest {
    private String credentialId;
    private Credential body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public PutIntegrationsCredentialRequest withCredentialId(String credentialId) {
        this.setCredentialId(credentialId);
        return this;
    }

    public Credential getBody() {
        return this.body;
    }

    public void setBody(Credential body) {
        this.body = body;
    }

    public PutIntegrationsCredentialRequest withBody(Credential body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutIntegrationsCredentialRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Credential> withHttpInfo() {
        if (this.credentialId == null) {
            throw new IllegalStateException("Missing the required parameter 'credentialId' when building request for PutIntegrationsCredentialRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/integrations/credentials/{credentialId}").withPathParameter("credentialId", this.credentialId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String credentialId) {
        return new Builder().withRequiredParams(credentialId);
    }

    public static class Builder {
        private final PutIntegrationsCredentialRequest request = new PutIntegrationsCredentialRequest();

        private Builder() {
        }

        public Builder withCredentialId(String credentialId) {
            this.request.setCredentialId(credentialId);
            return this;
        }

        public Builder withBody(Credential body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String credentialId) {
            this.request.setCredentialId(credentialId);
            return this;
        }

        public PutIntegrationsCredentialRequest build() {
            if (this.request.credentialId == null) {
                throw new IllegalStateException("Missing the required parameter 'credentialId' when building request for PutIntegrationsCredentialRequest.");
            }
            return this.request;
        }
    }
}

