/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Edge;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class InstanceInfo
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private Edge edge = null;
    private Integer assignedPhoneCount = null;
    private String ami = null;

    public InstanceInfo id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the ec2 instance.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public InstanceInfo state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of the instance in AWS")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public InstanceInfo edge(Edge edge) {
        this.edge = edge;
        return this;
    }

    @ApiModelProperty(example="null", value="Edge object that the instance is associated with.")
    @JsonProperty(value="edge")
    public Edge getEdge() {
        return this.edge;
    }

    public void setEdge(Edge edge) {
        this.edge = edge;
    }

    public InstanceInfo assignedPhoneCount(Integer assignedPhoneCount) {
        this.assignedPhoneCount = assignedPhoneCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of phones assigned to the edge.")
    @JsonProperty(value="assignedPhoneCount")
    public Integer getAssignedPhoneCount() {
        return this.assignedPhoneCount;
    }

    public void setAssignedPhoneCount(Integer assignedPhoneCount) {
        this.assignedPhoneCount = assignedPhoneCount;
    }

    public InstanceInfo ami(String ami) {
        this.ami = ami;
        return this;
    }

    @ApiModelProperty(example="null", value="The image id of the instance.")
    @JsonProperty(value="ami")
    public String getAmi() {
        return this.ami;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceInfo instanceInfo = (InstanceInfo)o;
        return Objects.equals(this.id, instanceInfo.id) && Objects.equals((Object)this.state, (Object)instanceInfo.state) && Objects.equals(this.edge, instanceInfo.edge) && Objects.equals(this.assignedPhoneCount, instanceInfo.assignedPhoneCount) && Objects.equals(this.ami, instanceInfo.ami);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.edge, this.assignedPhoneCount, this.ami});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstanceInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    edge: ").append(this.toIndentedString(this.edge)).append("\n");
        sb.append("    assignedPhoneCount: ").append(this.toIndentedString(this.assignedPhoneCount)).append("\n");
        sb.append("    ami: ").append(this.toIndentedString(this.ami)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REBOOTING("rebooting"),
        PENDING("pending"),
        RUNNING("running"),
        TERMINATED("terminated"),
        STOPPING("stopping"),
        STOPPED("stopped");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

