/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DataColumn;
import com.mypurecloud.sdk.v2.model.TimeZone;
import com.mypurecloud.sdk.v2.model.ViewFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReportingExportJobRequest
implements Serializable {
    private String name = null;
    private TimeZone timeZone = null;
    private ExportFormatEnum exportFormat = null;
    private String interval = null;
    private List<DataColumn> dataColumns = new ArrayList<DataColumn>();
    private String period = null;
    private ViewTypeEnum viewType = null;
    private ViewFilter filter = null;
    private Boolean read = null;

    public ReportingExportJobRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user supplied name of the export request")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReportingExportJobRequest timeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The requested timezone of the exported data")
    @JsonProperty(value="timeZone")
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public ReportingExportJobRequest exportFormat(ExportFormatEnum exportFormat) {
        this.exportFormat = exportFormat;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The requested format of the exported data")
    @JsonProperty(value="exportFormat")
    public ExportFormatEnum getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(ExportFormatEnum exportFormat) {
        this.exportFormat = exportFormat;
    }

    public ReportingExportJobRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", value="The time period used to limit the the exported data. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public ReportingExportJobRequest dataColumns(List<DataColumn> dataColumns) {
        this.dataColumns = dataColumns;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The data columns included in the export")
    @JsonProperty(value="dataColumns")
    public List<DataColumn> getDataColumns() {
        return this.dataColumns;
    }

    public void setDataColumns(List<DataColumn> dataColumns) {
        this.dataColumns = dataColumns;
    }

    public ReportingExportJobRequest period(String period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(example="null", value="The Period of the request in which to break down the intervals. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H")
    @JsonProperty(value="period")
    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public ReportingExportJobRequest viewType(ViewTypeEnum viewType) {
        this.viewType = viewType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of view export job to be created")
    @JsonProperty(value="viewType")
    public ViewTypeEnum getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewTypeEnum viewType) {
        this.viewType = viewType;
    }

    public ReportingExportJobRequest filter(ViewFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Filters to apply to create the view")
    @JsonProperty(value="filter")
    public ViewFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ViewFilter filter) {
        this.filter = filter;
    }

    public ReportingExportJobRequest read(Boolean read) {
        this.read = read;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the request has been marked as read")
    @JsonProperty(value="read")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportingExportJobRequest reportingExportJobRequest = (ReportingExportJobRequest)o;
        return Objects.equals(this.name, reportingExportJobRequest.name) && Objects.equals(this.timeZone, reportingExportJobRequest.timeZone) && Objects.equals((Object)this.exportFormat, (Object)reportingExportJobRequest.exportFormat) && Objects.equals(this.interval, reportingExportJobRequest.interval) && Objects.equals(this.dataColumns, reportingExportJobRequest.dataColumns) && Objects.equals(this.period, reportingExportJobRequest.period) && Objects.equals((Object)this.viewType, (Object)reportingExportJobRequest.viewType) && Objects.equals(this.filter, reportingExportJobRequest.filter) && Objects.equals(this.read, reportingExportJobRequest.read);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.timeZone, this.exportFormat, this.interval, this.dataColumns, this.period, this.viewType, this.filter, this.read});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportingExportJobRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    exportFormat: ").append(this.toIndentedString((Object)this.exportFormat)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    dataColumns: ").append(this.toIndentedString(this.dataColumns)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    viewType: ").append(this.toIndentedString((Object)this.viewType)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ViewTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUE_PERFORMANCE_SUMMARY_VIEW("QUEUE_PERFORMANCE_SUMMARY_VIEW"),
        QUEUE_PERFORMANCE_DETAIL_VIEW("QUEUE_PERFORMANCE_DETAIL_VIEW"),
        INTERACTION_SEARCH_VIEW("INTERACTION_SEARCH_VIEW"),
        AGENT_PERFORMANCE_SUMMARY_VIEW("AGENT_PERFORMANCE_SUMMARY_VIEW"),
        AGENT_PERFORMANCE_DETAIL_VIEW("AGENT_PERFORMANCE_DETAIL_VIEW"),
        AGENT_STATUS_SUMMARY_VIEW("AGENT_STATUS_SUMMARY_VIEW"),
        AGENT_STATUS_DETAIL_VIEW("AGENT_STATUS_DETAIL_VIEW"),
        AGENT_EVALUATION_SUMMARY_VIEW("AGENT_EVALUATION_SUMMARY_VIEW"),
        AGENT_EVALUATION_DETAIL_VIEW("AGENT_EVALUATION_DETAIL_VIEW"),
        AGENT_QUEUE_DETAIL_VIEW("AGENT_QUEUE_DETAIL_VIEW"),
        AGENT_INTERACTION_DETAIL_VIEW("AGENT_INTERACTION_DETAIL_VIEW"),
        ABANDON_INSIGHTS_VIEW("ABANDON_INSIGHTS_VIEW"),
        SKILLS_PERFORMANCE_VIEW("SKILLS_PERFORMANCE_VIEW");

        private String value;

        private ViewTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ViewTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ViewTypeEnum value : ViewTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ViewTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ExportFormatEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CSV("CSV");

        private String value;

        private ExportFormatEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExportFormatEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExportFormatEnum value : ExportFormatEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExportFormatEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

