/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteOauthClientRequest {
    private String clientId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public DeleteOauthClientRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteOauthClientRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.clientId == null) {
            throw new IllegalStateException("Missing the required parameter 'clientId' when building request for DeleteOauthClientRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/oauth/clients/{clientId}").withPathParameter("clientId", this.clientId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String clientId) {
        return new Builder().withRequiredParams(clientId);
    }

    public static class Builder {
        private final DeleteOauthClientRequest request = new DeleteOauthClientRequest();

        private Builder() {
        }

        public Builder withClientId(String clientId) {
            this.request.setClientId(clientId);
            return this;
        }

        public Builder withRequiredParams(String clientId) {
            this.request.setClientId(clientId);
            return this;
        }

        public DeleteOauthClientRequest build() {
            if (this.request.clientId == null) {
                throw new IllegalStateException("Missing the required parameter 'clientId' when building request for DeleteOauthClientRequest.");
            }
            return this.request;
        }
    }
}

