/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.EvaluationForm;
import java.util.HashMap;
import java.util.Map;

public class PutQualityFormRequest {
    private String formId;
    private EvaluationForm body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public PutQualityFormRequest withFormId(String formId) {
        this.setFormId(formId);
        return this;
    }

    public EvaluationForm getBody() {
        return this.body;
    }

    public void setBody(EvaluationForm body) {
        this.body = body;
    }

    public PutQualityFormRequest withBody(EvaluationForm body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutQualityFormRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<EvaluationForm> withHttpInfo() {
        if (this.formId == null) {
            throw new IllegalStateException("Missing the required parameter 'formId' when building request for PutQualityFormRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityFormRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/quality/forms/{formId}").withPathParameter("formId", this.formId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String formId, EvaluationForm body) {
        return new Builder().withRequiredParams(formId, body);
    }

    public static class Builder {
        private final PutQualityFormRequest request = new PutQualityFormRequest();

        private Builder() {
        }

        public Builder withFormId(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public Builder withBody(EvaluationForm body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String formId, EvaluationForm body) {
            this.request.setFormId(formId);
            this.request.setBody(body);
            return this;
        }

        public PutQualityFormRequest build() {
            if (this.request.formId == null) {
                throw new IllegalStateException("Missing the required parameter 'formId' when building request for PutQualityFormRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityFormRequest.");
            }
            return this.request;
        }
    }
}

