/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.MediaParticipantRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchConversationsCallbackParticipantCommunicationRequest {
    private String callbackId;
    private String participantId;
    private String communicationId;
    private MediaParticipantRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public PatchConversationsCallbackParticipantCommunicationRequest withCallbackId(String callbackId) {
        this.setCallbackId(callbackId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsCallbackParticipantCommunicationRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public PatchConversationsCallbackParticipantCommunicationRequest withCommunicationId(String communicationId) {
        this.setCommunicationId(communicationId);
        return this;
    }

    public MediaParticipantRequest getBody() {
        return this.body;
    }

    public void setBody(MediaParticipantRequest body) {
        this.body = body;
    }

    public PatchConversationsCallbackParticipantCommunicationRequest withBody(MediaParticipantRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsCallbackParticipantCommunicationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<MediaParticipantRequest> withHttpInfo() {
        if (this.callbackId == null) {
            throw new IllegalStateException("Missing the required parameter 'callbackId' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
        }
        if (this.communicationId == null) {
            throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId}").withPathParameter("callbackId", this.callbackId).withPathParameter("participantId", this.participantId).withPathParameter("communicationId", this.communicationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callbackId, String participantId, String communicationId, MediaParticipantRequest body) {
        return new Builder().withRequiredParams(callbackId, participantId, communicationId, body);
    }

    public static class Builder {
        private final PatchConversationsCallbackParticipantCommunicationRequest request = new PatchConversationsCallbackParticipantCommunicationRequest();

        private Builder() {
        }

        public Builder withCallbackId(String callbackId) {
            this.request.setCallbackId(callbackId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withCommunicationId(String communicationId) {
            this.request.setCommunicationId(communicationId);
            return this;
        }

        public Builder withBody(MediaParticipantRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String callbackId, String participantId, String communicationId, MediaParticipantRequest body) {
            this.request.setCallbackId(callbackId);
            this.request.setParticipantId(participantId);
            this.request.setCommunicationId(communicationId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsCallbackParticipantCommunicationRequest build() {
            if (this.request.callbackId == null) {
                throw new IllegalStateException("Missing the required parameter 'callbackId' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
            }
            if (this.request.communicationId == null) {
                throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsCallbackParticipantCommunicationRequest.");
            }
            return this.request;
        }
    }
}

