/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.RuleSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutOutboundRulesetRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String ruleSetId;
    private RuleSet body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleSetId() {
        return this.ruleSetId;
    }

    public void setRuleSetId(String ruleSetId) {
        this.ruleSetId = ruleSetId;
    }

    public PutOutboundRulesetRequest withRuleSetId(String ruleSetId) {
        this.setRuleSetId(ruleSetId);
        return this;
    }

    public RuleSet getBody() {
        return this.body;
    }

    public void setBody(RuleSet body) {
        this.body = body;
    }

    public PutOutboundRulesetRequest withBody(RuleSet body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOutboundRulesetRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RuleSet> withHttpInfo() {
        if (this.ruleSetId == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleSetId' when building request for PutOutboundRulesetRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOutboundRulesetRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/outbound/rulesets/{ruleSetId}").withPathParameter("ruleSetId", this.ruleSetId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleSetId, RuleSet body) {
        return new Builder().withRequiredParams(ruleSetId, body);
    }

    public static class Builder {
        private final PutOutboundRulesetRequest request = new PutOutboundRulesetRequest();

        private Builder() {
        }

        public Builder withRuleSetId(String ruleSetId) {
            this.request.setRuleSetId(ruleSetId);
            return this;
        }

        public Builder withBody(RuleSet body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String ruleSetId, RuleSet body) {
            this.request.setRuleSetId(ruleSetId);
            this.request.setBody(body);
            return this;
        }

        public PutOutboundRulesetRequest build() {
            return this.request;
        }
    }
}

