/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetLicenseDefinitionRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String licenseId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public GetLicenseDefinitionRequest withLicenseId(String licenseId) {
        this.setLicenseId(licenseId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetLicenseDefinitionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.licenseId == null) {
            throw new IllegalStateException("Missing the required parameter 'licenseId' when building request for GetLicenseDefinitionRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/license/definitions/{licenseId}").withPathParameter("licenseId", this.licenseId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String licenseId) {
        return new Builder().withRequiredParams(licenseId);
    }

    public static class Builder {
        private final GetLicenseDefinitionRequest request = new GetLicenseDefinitionRequest();

        private Builder() {
        }

        public Builder withLicenseId(String licenseId) {
            this.request.setLicenseId(licenseId);
            return this;
        }

        public Builder withRequiredParams(String licenseId) {
            this.request.setLicenseId(licenseId);
            return this;
        }

        public GetLicenseDefinitionRequest build() {
            return this.request;
        }
    }
}

