/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import com.mypurecloud.sdk.v2.ApiDateFormat;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ApiRequestBuilder<T> {
    private static final DateFormat DATE_FORMAT;
    private static final String[] EMPTY;
    private final String method;
    private final String path;
    private final Map<String, String> pathParams;
    private final Map<String, Object> formParams;
    private final List<Pair> queryParams;
    private final Map<String, String> headerParams;
    private final Map<String, String> customHeaders;
    private String[] contentTypes = EMPTY;
    private String[] accepts = EMPTY;
    private T body;
    private String[] authNames = EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatDate(Date date) {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    private static String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return ApiRequestBuilder.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    private static List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, ApiRequestBuilder.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, ApiRequestBuilder.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(ApiRequestBuilder.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    private static boolean isJsonMime(String mime) {
        return mime != null && mime.matches("(?i)application\\/json(;.*)?");
    }

    private static String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!ApiRequestBuilder.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    private static String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!ApiRequestBuilder.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    private static String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static ApiRequestBuilder<Void> create(String method, String path) {
        return new ApiRequestBuilder<Void>(method, path);
    }

    private ApiRequestBuilder(String method, String path) {
        this.method = method;
        this.path = path;
        this.pathParams = new HashMap<String, String>();
        this.formParams = new HashMap<String, Object>();
        this.queryParams = new ArrayList<Pair>();
        this.headerParams = new HashMap<String, String>();
        this.customHeaders = new HashMap<String, String>();
    }

    private ApiRequestBuilder(ApiRequestBuilder<?> parent, T body) {
        this.method = parent.method;
        this.path = parent.path;
        this.pathParams = parent.pathParams;
        this.formParams = parent.formParams;
        this.queryParams = parent.queryParams;
        this.headerParams = parent.headerParams;
        this.customHeaders = parent.customHeaders;
        this.contentTypes = parent.contentTypes;
        this.accepts = parent.accepts;
        this.body = body;
        this.authNames = parent.authNames;
    }

    public ApiRequestBuilder<T> withPathParameter(String name, Object value) {
        if (value != null) {
            this.pathParams.put(name, ApiRequestBuilder.escapeString(value.toString()));
        } else {
            this.pathParams.remove(name);
        }
        return this;
    }

    public ApiRequestBuilder<T> withFormParameter(String name, Object value) {
        this.formParams.put(name, value);
        return this;
    }

    public ApiRequestBuilder<T> withQueryParameters(String name, String collectionFormat, Object value) {
        this.queryParams.addAll(ApiRequestBuilder.parameterToPairs(collectionFormat, name, value));
        return this;
    }

    public ApiRequestBuilder<T> withHeaderParameter(String name, Object value) {
        if (value != null) {
            this.headerParams.put(name, ApiRequestBuilder.parameterToString(value));
        } else {
            this.headerParams.remove(name);
        }
        return this;
    }

    public ApiRequestBuilder<T> withCustomHeader(String name, String value) {
        if (value != null) {
            this.customHeaders.put(name, value);
        } else {
            this.customHeaders.remove(name);
        }
        return this;
    }

    public ApiRequestBuilder<T> withCustomHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.customHeaders.putAll(headers);
        }
        return this;
    }

    public ApiRequestBuilder<T> withContentTypes(String ... contentTypes) {
        this.contentTypes = contentTypes != null ? contentTypes : EMPTY;
        return this;
    }

    public ApiRequestBuilder<T> withAccepts(String ... accepts) {
        this.accepts = accepts != null ? accepts : EMPTY;
        return this;
    }

    public ApiRequestBuilder<T> withAuthNames(String ... authNames) {
        this.authNames = authNames != null ? authNames : EMPTY;
        return this;
    }

    public <BODY> ApiRequestBuilder<BODY> withBody(BODY body) {
        return new ApiRequestBuilder<BODY>(this, body);
    }

    public ApiRequest<T> build() {
        final Map<String, String> pathParams = Collections.unmodifiableMap(this.pathParams);
        final Map<String, Object> formParams = Collections.unmodifiableMap(this.formParams);
        final List<Pair> queryParams = Collections.unmodifiableList(this.queryParams);
        final Map<String, String> headerParams = Collections.unmodifiableMap(this.headerParams);
        final Map<String, String> customHeaders = Collections.unmodifiableMap(this.customHeaders);
        final String contentType = ApiRequestBuilder.selectHeaderContentType(this.contentTypes);
        final String accepts = ApiRequestBuilder.selectHeaderAccept(this.accepts);
        final T body = this.body;
        final String[] authNames = this.authNames;
        return new ApiRequest<T>(){

            @Override
            public String getPath() {
                return ApiRequestBuilder.this.path;
            }

            @Override
            public String getMethod() {
                return ApiRequestBuilder.this.method;
            }

            @Override
            public Map<String, String> getPathParams() {
                return pathParams;
            }

            @Override
            public List<Pair> getQueryParams() {
                return queryParams;
            }

            @Override
            public Map<String, Object> getFormParams() {
                return formParams;
            }

            @Override
            public Map<String, String> getHeaderParams() {
                return headerParams;
            }

            @Override
            public Map<String, String> getCustomHeaders() {
                return customHeaders;
            }

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            public String getAccepts() {
                return accepts;
            }

            @Override
            public T getBody() {
                return body;
            }

            @Override
            public String[] getAuthNames() {
                return authNames;
            }

            public String toString() {
                return "ApiRequest { " + ApiRequestBuilder.this.method + " " + ApiRequestBuilder.this.path + " }";
            }
        };
    }

    static {
        EMPTY = new String[0];
        DATE_FORMAT = new ApiDateFormat();
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

