/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.GetScriptPageRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptPagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdPageRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdPagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdVariablesRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsRequest;
import com.mypurecloud.sdk.v2.model.Page;
import com.mypurecloud.sdk.v2.model.Script;
import com.mypurecloud.sdk.v2.model.ScriptEntityListing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ScriptsApi {
    private final ApiClient pcapiClient;

    public ScriptsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScriptsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Script getScript(String scriptId) throws IOException, ApiException {
        return this.getScriptWithHttpInfo(scriptId).getBody();
    }

    public ApiResponse<Script> getScriptWithHttpInfo(String scriptId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (scriptId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'scriptId' when calling getScript");
        }
        String pclocalVarPath = "/api/v2/scripts/{scriptId}".replaceAll("\\{format\\}", "json").replaceAll("\\{scriptId\\}", this.pcapiClient.escapeString(scriptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Script>(){});
    }

    public Script getScript(GetScriptRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Script>(){});
    }

    public ApiResponse<Script> getScript(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Script>(){});
    }

    public Page getScriptPage(String scriptId, String pageId) throws IOException, ApiException {
        return this.getScriptPageWithHttpInfo(scriptId, pageId).getBody();
    }

    public ApiResponse<Page> getScriptPageWithHttpInfo(String scriptId, String pageId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (scriptId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'scriptId' when calling getScriptPage");
        }
        if (pageId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'pageId' when calling getScriptPage");
        }
        String pclocalVarPath = "/api/v2/scripts/{scriptId}/pages/{pageId}".replaceAll("\\{format\\}", "json").replaceAll("\\{scriptId\\}", this.pcapiClient.escapeString(scriptId.toString())).replaceAll("\\{pageId\\}", this.pcapiClient.escapeString(pageId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Page>(){});
    }

    public Page getScriptPage(GetScriptPageRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Page>(){});
    }

    public ApiResponse<Page> getScriptPage(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Page>(){});
    }

    public List<Page> getScriptPages(String scriptId) throws IOException, ApiException {
        return this.getScriptPagesWithHttpInfo(scriptId).getBody();
    }

    public ApiResponse<List<Page>> getScriptPagesWithHttpInfo(String scriptId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (scriptId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'scriptId' when calling getScriptPages");
        }
        String pclocalVarPath = "/api/v2/scripts/{scriptId}/pages".replaceAll("\\{format\\}", "json").replaceAll("\\{scriptId\\}", this.pcapiClient.escapeString(scriptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<List<Page>>(){});
    }

    public List<Page> getScriptPages(GetScriptPagesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<List<Page>>(){});
    }

    public ApiResponse<List<Page>> getScriptPages(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<List<Page>>(){});
    }

    public ScriptEntityListing getScripts(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId, String sortBy, String sortOrder) throws IOException, ApiException {
        return this.getScriptsWithHttpInfo(pageSize, pageNumber, expand, name, feature, flowId, sortBy, sortOrder).getBody();
    }

    public ApiResponse<ScriptEntityListing> getScriptsWithHttpInfo(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId, String sortBy, String sortOrder) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/scripts".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "feature", feature));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "flowId", flowId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortOrder", sortOrder));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<ScriptEntityListing>(){});
    }

    public ScriptEntityListing getScripts(GetScriptsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<ScriptEntityListing>(){});
    }

    public ApiResponse<ScriptEntityListing> getScripts(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<ScriptEntityListing>(){});
    }

    public ScriptEntityListing getScriptsPublished(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId) throws IOException, ApiException {
        return this.getScriptsPublishedWithHttpInfo(pageSize, pageNumber, expand, name, feature, flowId).getBody();
    }

    public ApiResponse<ScriptEntityListing> getScriptsPublishedWithHttpInfo(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/scripts/published".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "feature", feature));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "flowId", flowId));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<ScriptEntityListing>(){});
    }

    public ScriptEntityListing getScriptsPublished(GetScriptsPublishedRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<ScriptEntityListing>(){});
    }

    public ApiResponse<ScriptEntityListing> getScriptsPublished(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<ScriptEntityListing>(){});
    }

    public Script getScriptsPublishedScriptId(String scriptId) throws IOException, ApiException {
        return this.getScriptsPublishedScriptIdWithHttpInfo(scriptId).getBody();
    }

    public ApiResponse<Script> getScriptsPublishedScriptIdWithHttpInfo(String scriptId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (scriptId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'scriptId' when calling getScriptsPublishedScriptId");
        }
        String pclocalVarPath = "/api/v2/scripts/published/{scriptId}".replaceAll("\\{format\\}", "json").replaceAll("\\{scriptId\\}", this.pcapiClient.escapeString(scriptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Script>(){});
    }

    public Script getScriptsPublishedScriptId(GetScriptsPublishedScriptIdRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Script>(){});
    }

    public ApiResponse<Script> getScriptsPublishedScriptId(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Script>(){});
    }

    public Page getScriptsPublishedScriptIdPage(String scriptId, String pageId) throws IOException, ApiException {
        return this.getScriptsPublishedScriptIdPageWithHttpInfo(scriptId, pageId).getBody();
    }

    public ApiResponse<Page> getScriptsPublishedScriptIdPageWithHttpInfo(String scriptId, String pageId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (scriptId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'scriptId' when calling getScriptsPublishedScriptIdPage");
        }
        if (pageId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'pageId' when calling getScriptsPublishedScriptIdPage");
        }
        String pclocalVarPath = "/api/v2/scripts/published/{scriptId}/pages/{pageId}".replaceAll("\\{format\\}", "json").replaceAll("\\{scriptId\\}", this.pcapiClient.escapeString(scriptId.toString())).replaceAll("\\{pageId\\}", this.pcapiClient.escapeString(pageId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Page>(){});
    }

    public Page getScriptsPublishedScriptIdPage(GetScriptsPublishedScriptIdPageRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Page>(){});
    }

    public ApiResponse<Page> getScriptsPublishedScriptIdPage(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Page>(){});
    }

    public List<Page> getScriptsPublishedScriptIdPages(String scriptId) throws IOException, ApiException {
        return this.getScriptsPublishedScriptIdPagesWithHttpInfo(scriptId).getBody();
    }

    public ApiResponse<List<Page>> getScriptsPublishedScriptIdPagesWithHttpInfo(String scriptId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (scriptId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'scriptId' when calling getScriptsPublishedScriptIdPages");
        }
        String pclocalVarPath = "/api/v2/scripts/published/{scriptId}/pages".replaceAll("\\{format\\}", "json").replaceAll("\\{scriptId\\}", this.pcapiClient.escapeString(scriptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<List<Page>>(){});
    }

    public List<Page> getScriptsPublishedScriptIdPages(GetScriptsPublishedScriptIdPagesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<List<Page>>(){});
    }

    public ApiResponse<List<Page>> getScriptsPublishedScriptIdPages(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<List<Page>>(){});
    }

    public Object getScriptsPublishedScriptIdVariables(String scriptId, String input, String output, String type) throws IOException, ApiException {
        return this.getScriptsPublishedScriptIdVariablesWithHttpInfo(scriptId, input, output, type).getBody();
    }

    public ApiResponse<Object> getScriptsPublishedScriptIdVariablesWithHttpInfo(String scriptId, String input, String output, String type) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (scriptId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'scriptId' when calling getScriptsPublishedScriptIdVariables");
        }
        String pclocalVarPath = "/api/v2/scripts/published/{scriptId}/variables".replaceAll("\\{format\\}", "json").replaceAll("\\{scriptId\\}", this.pcapiClient.escapeString(scriptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "input", input));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "output", output));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "type", type));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Object>(){});
    }

    public Object getScriptsPublishedScriptIdVariables(GetScriptsPublishedScriptIdVariablesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Object>(){});
    }

    public ApiResponse<Object> getScriptsPublishedScriptIdVariables(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Object>(){});
    }
}

