/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class HeartBeatAlert
implements Serializable {
    private String id = null;
    private String name = null;
    private String senderId = null;
    private Integer heartBeatTimeoutInMinutes = null;
    private String ruleId = null;
    private Date startDate = null;
    private Date endDate = null;
    private List<User> notificationUsers = new ArrayList<User>();
    private List<AlertTypesEnum> alertTypes = new ArrayList<AlertTypesEnum>();
    private RuleTypeEnum ruleType = null;
    private String ruleUri = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public HeartBeatAlert name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the rule")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HeartBeatAlert senderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value that identifies the sender of the heartbeat.")
    @JsonProperty(value="senderId")
    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public HeartBeatAlert heartBeatTimeoutInMinutes(Integer heartBeatTimeoutInMinutes) {
        this.heartBeatTimeoutInMinutes = heartBeatTimeoutInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of minutes to wait before alerting missing heartbeats.")
    @JsonProperty(value="heartBeatTimeoutInMinutes")
    public Integer getHeartBeatTimeoutInMinutes() {
        return this.heartBeatTimeoutInMinutes;
    }

    public void setHeartBeatTimeoutInMinutes(Integer heartBeatTimeoutInMinutes) {
        this.heartBeatTimeoutInMinutes = heartBeatTimeoutInMinutes;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the rule.")
    @JsonProperty(value="ruleId")
    public String getRuleId() {
        return this.ruleId;
    }

    @ApiModelProperty(example="null", required=true, value="The date/time the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @ApiModelProperty(example="null", value="The date/time the owning rule exiting in alarm status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public HeartBeatAlert notificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ids of users who were notified of alarm state change.")
    @JsonProperty(value="notificationUsers")
    public List<User> getNotificationUsers() {
        return this.notificationUsers;
    }

    public void setNotificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
    }

    public HeartBeatAlert alertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A collection of notification methods.")
    @JsonProperty(value="alertTypes")
    public List<AlertTypesEnum> getAlertTypes() {
        return this.alertTypes;
    }

    public void setAlertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
    }

    public HeartBeatAlert ruleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of heartbeat rule that generated the alert")
    @JsonProperty(value="ruleType")
    public RuleTypeEnum getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
    }

    public HeartBeatAlert ruleUri(String ruleUri) {
        this.ruleUri = ruleUri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="ruleUri")
    public String getRuleUri() {
        return this.ruleUri;
    }

    public void setRuleUri(String ruleUri) {
        this.ruleUri = ruleUri;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeartBeatAlert heartBeatAlert = (HeartBeatAlert)o;
        return Objects.equals(this.id, heartBeatAlert.id) && Objects.equals(this.name, heartBeatAlert.name) && Objects.equals(this.senderId, heartBeatAlert.senderId) && Objects.equals(this.heartBeatTimeoutInMinutes, heartBeatAlert.heartBeatTimeoutInMinutes) && Objects.equals(this.ruleId, heartBeatAlert.ruleId) && Objects.equals(this.startDate, heartBeatAlert.startDate) && Objects.equals(this.endDate, heartBeatAlert.endDate) && Objects.equals(this.notificationUsers, heartBeatAlert.notificationUsers) && Objects.equals(this.alertTypes, heartBeatAlert.alertTypes) && Objects.equals((Object)this.ruleType, (Object)heartBeatAlert.ruleType) && Objects.equals(this.ruleUri, heartBeatAlert.ruleUri) && Objects.equals(this.selfUri, heartBeatAlert.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.senderId, this.heartBeatTimeoutInMinutes, this.ruleId, this.startDate, this.endDate, this.notificationUsers, this.alertTypes, this.ruleType, this.ruleUri, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeartBeatAlert {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    senderId: ").append(this.toIndentedString(this.senderId)).append("\n");
        sb.append("    heartBeatTimeoutInMinutes: ").append(this.toIndentedString(this.heartBeatTimeoutInMinutes)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    notificationUsers: ").append(this.toIndentedString(this.notificationUsers)).append("\n");
        sb.append("    alertTypes: ").append(this.toIndentedString(this.alertTypes)).append("\n");
        sb.append("    ruleType: ").append(this.toIndentedString((Object)this.ruleType)).append("\n");
        sb.append("    ruleUri: ").append(this.toIndentedString(this.ruleUri)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RuleTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EDGE("EDGE");

        private String value;

        private RuleTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RuleTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RuleTypeEnum value : RuleTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RuleTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum AlertTypesEnum {
        SMS("SMS"),
        DEVICE("DEVICE"),
        EMAIL("EMAIL");

        private String value;

        private AlertTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlertTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlertTypesEnum value : AlertTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlertTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

