/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.User;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchUserRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String userId;
    private User body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchUserRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public User getBody() {
        return this.body;
    }

    public void setBody(User body) {
        this.body = body;
    }

    public PatchUserRequest withBody(User body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchUserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<User> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/users/{userId}").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, User body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PatchUserRequest request = new PatchUserRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(User body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, User body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PatchUserRequest build() {
            return this.request;
        }
    }
}

