/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Conversation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchConversationsChatRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String chatId;
    private Conversation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public PatchConversationsChatRequest withChatId(String chatId) {
        this.setChatId(chatId);
        return this;
    }

    public Conversation getBody() {
        return this.body;
    }

    public void setBody(Conversation body) {
        this.body = body;
    }

    public PatchConversationsChatRequest withBody(Conversation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsChatRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Conversation> withHttpInfo() {
        if (this.chatId == null) {
            throw new IllegalStateException("Missing the required parameter 'chatId' when building request for PatchConversationsChatRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsChatRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/chats/{chatId}").withPathParameter("chatId", this.chatId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String chatId, Conversation body) {
        return new Builder().withRequiredParams(chatId, body);
    }

    public static class Builder {
        private final PatchConversationsChatRequest request = new PatchConversationsChatRequest();

        private Builder() {
        }

        public Builder withChatId(String chatId) {
            this.request.setChatId(chatId);
            return this;
        }

        public Builder withBody(Conversation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String chatId, Conversation body) {
            this.request.setChatId(chatId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsChatRequest build() {
            return this.request;
        }
    }
}

